<?php namespace DistrictHub\Directory\Listeners;

use DistrictHub\Directory\Events\ChurchWasCreated;
use DistrictHub\Support\Listeners\Notification;

class AlertChurchCreated extends Notification
{
    /**
     * Handle the event.
     *
     * @param  ChurchWasCreated $event
     *
     * @return void
     */
    public function handle(ChurchWasCreated $event)
    {
        $url = route('churches.edit', [$event->church->id]);
        $this->notifier->success("Created Church \"<a href=\"{$url}\">{$event->church->name}</a>\"");
    }
}
