<!doctype html>
<html>
    <head>
        <meta charset='utf-8'>
        <title>Circuit Directory</title>
        <link type="text/css" rel="stylesheet" href="{{ url(mix('css/print.css')) }}">
    </head>
    <body>
        <script type="text/php">
            $font = $fontMetrics->get_font('Helvetica, Arial, sans-serif', 'normal');
            $GLOBALS['chapters'] = array();
            $GLOBALS['backside'] = $pdf->open_object();
        </script>
        <div class="page page--preface">
            <h1 class="title">
                {{ $circuit->name }} Methodist Circuit {{ $circuit->district->number }}/{{ $circuit->number }}
                <small>Circuit Directory {{ date('Y') }}/{{ Carbon\Carbon::create()->addYear(1)->format('y') }}</small>
            </h1>
            <p class="sub-title">
                Registered Charity No. {{ $circuit->charity_number }}
                <br>
                Website: {{ $circuit->website }}
            </p>
            <h2 class="heading">Welcome</h2>
            <p>
                Welcome to the Circuit Directory for Birmingham Methodist Circuit. This document includes the
                information and contact details for everyone who holds a role within the thirty seven churches
                which make up our circuit, as well as the different Circuit Roles to which people from our
                churches are appointed by our Circuit Assembly. This includes Circuit Leadership, Circuit
                Forums, as well as Local Preachers. In addition to this it also contains the details of the Ministers
                Stationed in our Circuit and the Lay Staff we employ across it, as well as contacts for both our
                District, the Queens Foundation and the Methodist Church.
            </p>
            <h2 class="heading">Data Protection</h2>
            <p>
                <strong>Protecting Data:</strong>
                We take the protection data in this directory very seriously. Please do not leave
                copies of this directory available to those not permitted to use it. For more details please turn to the
                inside back cover for full details about the Circuit Directory and Data Protection.
            </p>
            <h2 class="heading">Index</h2>
            <table class="table">
                <thead>
                    <tr>
                        <th>Information</th>
                        <th width="20%">Page no.</th>
                    </tr>
                </thead>
                <tbody>
                    <tr>
                        <td>Quick Circuit Contacts</td>
                        <td>%%CH1%%</td>
                    </tr>
                    <tr>
                        <td>Circuit Officers</td>
                        <td>%%CH2%%</td>
                    </tr>
                    <tr>
                        <td>Forums</td>
                        <td>%%CH3%%</td>
                    </tr>
                    <tr>
                        <td>Ministers</td>
                        <td>%%CH4%%</td>
                    </tr>
                    <tr>
                        <td>Circuit Staff</td>
                        <td>%%CH5%%</td>
                    </tr>
                    <tr>
                        <td>Lay Chaplains</td>
                        <td>%%CH6%%</td>
                    </tr>
                    <tr>
                        <td>Local Preachers</td>
                        <td>%%CH7%%</td>
                    </tr>
                    <tr>
                        <td>{{ $circuit->district->name }} Contacts</td>
                        <td>%%CH8%%</td>
                    </tr>
                    <tr>
                        <td>{{ $queens->name }} Contacts</td>
                        <td>%%CH9%%</td>
                    </tr>
                    <tr>
                        <td>Churches</td>
                        <td>%%CH10%%</td>
                    </tr>
                    <tr>
                        <td>A-Z Index of all Birmingham Circuit Contacts</td>
                        <td>%%CH11%%</td>
                    </tr>
                </tbody>
            </table>
            <div class="footer"></div>
            <script type="text/php">$pdf->close_object();</script>
        </div>
        <div class="page">
            <script type="text/php">$GLOBALS['chapters']['1'] = $pdf->get_page_number();</script>
            <h2 class="heading">Quick Circuit Contacts</h2>
            <p>
                Below are a list of key important or emergency contacts for our Circuit. The full details of individuals
                can be found in the A-Z index at the back of the directory.
            </p>
            <h3 class="sub-heading">Circuit Superintendents</h3>
            <table class="table">
                <thead>
                    <tr>
                        <th width="30%">Name</th>
                        <th>Email</th>
                        <th width="20%">Phone</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach($superintendents as $member)
                        <tr>
                            <td>{{ $member->name }}</td>
                            <td>
                                @if($member->primary_email)
                                    {{ $member->primary_email->address }}
                                @endif
                            </td>
                            <td>
                                @foreach($member->phones as $phone)
                                    @if($loop->count > 1)
                                        {{ substr($phone->type->description, 0, 1) }}:
                                    @endif
                                    {{ $phone->number }}<br>
                                @endforeach
                            </td>
                        </tr>
                    @endforeach
                </tbody>
            </table>
            <h3 class="sub-heading">Church Contacts</h3>
            <p>
                For any matter relating to your church or to get in touch with another church, please
                see the churches section of this directory which will give details of who to contact.
            </p>
            <h3 class="sub-heading">Safeguarding</h3>
            <p>
                If you need to discuss a safeguarding matter relating to your church please contact
                your church safeguarding officer. If you cannot reach them please either contact our
                District Safeguarding Officer in an urgent situation (details below) or in a less urgent
                situation, please contact our circuit safeguarding team.
            </p>
            <table class="table">
                <thead>
                    <tr>
                        <th width="30%">Name</th>
                        <th>Email</th>
                        <th width="20%">Phone</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach($safeguarding as $member)
                        <tr>
                            <td>{{ $member->name }}</td>
                            <td>
                                @if($member->primary_email)
                                    {{ $member->primary_email->address }}
                                @endif
                            </td>
                            <td>
                                @foreach($member->phones as $phone)
                                    @if($loop->count > 1)
                                        {{ substr($phone->type->description, 0, 1) }}:
                                    @endif
                                    {{ $phone->number }}<br>
                                @endforeach
                            </td>
                        </tr>
                    @endforeach
                </tbody>
            </table>
            <h3 class="sub-heading">Get in touch with the Office</h3>
            <p>
                If you have queries about the <strong>plan</strong>, <strong>property</strong>,
                <strong>personnel</strong>, <strong>statistics</strong>, <strong>finance</strong>,
                <strong>communication</strong>, <strong>training</strong>, or <strong>any other query</strong>.
                Please contact the Central Office using the details bellow.
            </p>
            <ul>
                <li>
                    <strong>Office Telephone:</strong>
                    0121 616 1800 (Leave a message if needed)
                </li>
                <li>
                    <strong>Office Email:</strong>
                    contact@birminghammethodistcircuit.org.uk
                </li>
                <li>
                    <strong>Post:</strong>
                    Central Office, The Church at Carrs Lane, Carrs Lane, Birmingham, B4 7SX
                </li>
            </ul>
            <div class="footer"></div>
        </div>
        <div class="page">
            <script type="text/php">$GLOBALS['chapters']['2'] = $pdf->get_page_number();</script>
            <h2 class="heading">{{ $circuit_officers->name }}</h2>
            @foreach($circuit_officers->roles()->orderBy('sort')->get() as $role)
                @if($role->members()->wherePivot('scope_id', $circuit->id)->count() > 0)
                    <table class="table">
                        <thead>
                            <tr>
                                <th colspan="3">{{ $role->name }}</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($role->members()->wherePivot('scope_id', $circuit->id)->orderBy('last_name')->get() as $member)
                                <tr>
                                    <td width="30%">{{ $member->name }}</td>
                                    <td>
                                        @if($member->primary_email)
                                            {{ $member->primary_email->address }}
                                        @endif
                                    </td>
                                    <td width="20%">
                                        @foreach($member->phones as $phone)
                                            @if($loop->count > 1)
                                                {{ substr($phone->type->description, 0, 1) }}:
                                            @endif
                                            {{ $phone->number }}<br>
                                        @endforeach
                                    </td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                @endif
            @endforeach
            @foreach($circuit_officers->roleGroups as $group)
                @if($group->roles->count() > 0)
                    <h3 class="sub-heading">{{ $group->name }}</h3>
                    @foreach($group->roles()->orderBy('sort')->get() as $groupRole)
                        @if($groupRole->members()->wherePivot('scope_id', $circuit->id)->count() > 0)
                            <table class="table">
                                <thead>
                                    <tr>
                                        <th colspan="3">{{ $groupRole->name }}</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach($groupRole->members()->wherePivot('scope_id', $circuit->id)->orderBy('last_name')->get() as $member)
                                        <tr>
                                            <td width="30%">{{ $member->name }}</td>
                                            <td>
                                                @if($member->primary_email)
                                                    {{ $member->primary_email->address }}
                                                @endif
                                            </td>
                                            <td width="20%">
                                                @foreach($member->phones as $phone)
                                                    @if($loop->count > 1)
                                                        {{ substr($phone->type->description, 0, 1) }}:
                                                    @endif
                                                    {{ $phone->number }}<br>
                                                @endforeach
                                            </td>
                                        </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        @endif
                    @endforeach
                @endif
            @endforeach
            <div class="footer"></div>
        </div>
        <div class="page">
            <script type="text/php">$GLOBALS['chapters']['3'] = $pdf->get_page_number();</script>
            <h2 class="heading">{{ $forum_contacts->name }}</h2>
            @foreach($forum_contacts->roles()->orderBy('sort')->get() as $role)
                @if($role->members()->wherePivot('scope_id', $circuit->id)->count() > 0)
                    <table class="table avoid-break">
                        <thead>
                            <tr>
                                <th colspan="3">{{ $role->name }}</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($role->members()->wherePivot('scope_id', $circuit->id)->orderBy('last_name')->get() as $member)
                                <tr>
                                    <td width="30%">{{ $member->name }}</td>
                                    <td>
                                        @if($member->primary_email)
                                            {{ $member->primary_email->address }}
                                        @endif
                                    </td>
                                    <td width="20%">
                                        @foreach($member->phones as $phone)
                                            @if($loop->count > 1)
                                                {{ substr($phone->type->description, 0, 1) }}:
                                            @endif
                                            {{ $phone->number }}<br>
                                        @endforeach
                                    </td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                @endif
            @endforeach
            @foreach($forum_contacts->roleGroups as $group)
                @if($group->roles->count() > 0)
                    <h3 class="sub-heading">{{ $group->name }}</h3>
                    @foreach($group->roles()->orderBy('sort')->get() as $groupRole)
                        @if($groupRole->members()->wherePivot('scope_id', $circuit->id)->count() > 0)
                            <table class="table avoid-break">
                                <thead>
                                    <tr>
                                        <th colspan="3">{{ $groupRole->name }}</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach($groupRole->members()->wherePivot('scope_id', $circuit->id)->orderBy('last_name')->get() as $member)
                                        <tr>
                                            <td width="30%">{{ $member->name }}</td>
                                            <td>
                                                @if($member->primary_email)
                                                    {{ $member->primary_email->address }}
                                                @endif
                                            </td>
                                            <td width="20%">
                                                @foreach($member->phones as $phone)
                                                    @if($loop->count > 1)
                                                        {{ substr($phone->type->description, 0, 1) }}:
                                                    @endif
                                                    {{ $phone->number }}<br>
                                                @endforeach
                                            </td>
                                        </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        @endif
                    @endforeach
                @endif
            @endforeach
            <div class="footer"></div>
        </div>
        <div class="page">
            <script type="text/php">$GLOBALS['chapters']['4'] = $pdf->get_page_number();</script>
            <h2 class="heading">{{ $ministers->name }}</h2>
            @foreach($ministers->roles()->orderBy('sort')->get() as $role)
                @if($role->members()->wherePivot('scope_id', $circuit->id)->count() > 0)
                    <table class="table">
                        <thead>
                            <tr>
                                <th colspan="3">{{ $role->name }}</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($role->members()->wherePivot('scope_id', $circuit->id)->orderBy('last_name')->get() as $member)
                                <tr>
                                    <td width="30%">{{ $member->name }}</td>
                                    <td>
                                        @if($member->primary_email)
                                            {{ $member->primary_email->address }}<br>
                                        @endif
                                        @if($member->primary_address)
                                            {{ $member->primary_address->full_address }}
                                        @endif
                                    </td>
                                    <td width="20%">
                                        @foreach($member->phones as $phone)
                                            @if($loop->count > 1)
                                                {{ substr($phone->type->description, 0, 1) }}:
                                            @endif
                                            {{ $phone->number }}<br>
                                        @endforeach
                                    </td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                @endif
            @endforeach
            @foreach($ministers->roleGroups as $group)
                @if($group->roles->count() > 0)
                    <h3 class="sub-heading">{{ $group->name }}</h3>
                    @foreach($group->roles()->orderBy('sort')->get() as $groupRole)
                        @if($groupRole->members()->wherePivot('scope_id', $circuit->id)->count() > 0)
                            <table class="table">
                                <thead>
                                    <tr>
                                        <th colspan="3">{{ $groupRole->name }}</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach($groupRole->members()->wherePivot('scope_id', $circuit->id)->orderBy('last_name')->get() as $member)
                                        <tr>
                                            <td width="30%">
                                                {{ $member->name }}
                                                @if($member->pivot->description)
                                                    <br><em>{{ $member->pivot->description }}</em>
                                                @endif
                                            </td>
                                            <td>
                                                @if($member->primary_email)
                                                    {{ $member->primary_email->address }}<br>
                                                @endif
                                                @if($member->primary_address)
                                                    {{ $member->primary_address->full_address }}
                                                @endif
                                            </td>
                                            <td width="20%">
                                                @foreach($member->phones as $phone)
                                                    @if($loop->count > 1)
                                                        {{ substr($phone->type->description, 0, 1) }}:
                                                    @endif
                                                    {{ $phone->number }}<br>
                                                @endforeach
                                            </td>
                                        </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        @endif
                    @endforeach
                @endif
            @endforeach
            <div class="footer"></div>
        </div>
        <div class="page">
            <script type="text/php">$GLOBALS['chapters']['5'] = $pdf->get_page_number();</script>
            <h2 class="heading">{{ $circuit_staff->name }}</h2>
            @foreach($circuit_staff->roles()->orderBy('sort')->get() as $role)
                @if($role->members()->wherePivot('scope_id', $circuit->id)->count() > 0)
                    <table class="table">
                        <tbody>
                            @foreach($role->members()->wherePivot('scope_id', $circuit->id)->orderBy('last_name')->get() as $member)
                                <tr>
                                    <td width="30%">{{ $member->name }}</td>
                                    <td>
                                        @if($member->primary_email)
                                            {{ $member->primary_email->address }}
                                        @endif
                                    </td>
                                    <td width="20%">
                                        @foreach($member->phones as $phone)
                                            @if($loop->count > 1)
                                                {{ substr($phone->type->description, 0, 1) }}:
                                            @endif
                                            {{ $phone->number }}<br>
                                        @endforeach
                                    </td>
                                </tr>
                                <tr>
                                    <td class="text-italic">{{ $role->name }}</td>
                                    <td colspan="2">{{ $member->pivot->description }}</td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                @endif
            @endforeach
            @foreach($circuit_staff->roleGroups as $group)
                @if($group->roles->count() > 0)
                    <h3 class="sub-heading">{{ $group->name }}</h3>
                    @foreach($group->roles()->orderBy('sort')->get() as $groupRole)
                        @if($groupRole->members()->wherePivot('scope_id', $circuit->id)->count() > 0)
                            <table class="table">
                                <tbody>
                                    @foreach($groupRole->members()->wherePivot('scope_id', $circuit->id)->orderBy('last_name')->get() as $member)
                                        <tr class="flush-bottom">
                                            <td width="30%">{{ $member->name }}</td>
                                            <td>
                                                @if($member->primary_email)
                                                    {{ $member->primary_email->address }}
                                                @endif
                                            </td>
                                            <td width="20%">
                                                @foreach($member->phones as $phone)
                                                    @if($loop->count > 1)
                                                        {{ substr($phone->type->description, 0, 1) }}:
                                                    @endif
                                                    {{ $phone->number }}<br>
                                                @endforeach
                                            </td>
                                        </tr>
                                        <tr>
                                            <td class="text-italic">{{ $groupRole->name }}</td>
                                            <td colspan="2">{{ $member->pivot->description }}</td>
                                        </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        @endif
                    @endforeach
                @endif
            @endforeach
            <div class="footer"></div>
        </div>
        <div class="page">
            <script type="text/php">$GLOBALS['chapters']['6'] = $pdf->get_page_number();</script>
            <h2 class="heading">{{ $lay_chaplains->name }}</h2>
            @foreach($lay_chaplains->roles()->orderBy('sort')->get() as $role)
                @if($role->members()->wherePivot('scope_id', $circuit->id)->count() > 0)
                    <table class="table">
                        <thead>
                            <tr>
                                <th colspan="3">{{ $role->name }}</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($role->members()->wherePivot('scope_id', $circuit->id)->orderBy('last_name')->get() as $member)
                                <tr class="flush-bottom">
                                    <td width="30%">{{ $member->name }}</td>
                                    <td>
                                        @if($member->primary_email)
                                            {{ $member->primary_email->address }}
                                        @endif
                                    </td>
                                    <td width="20%">
                                        @foreach($member->phones as $phone)
                                            @if($loop->count > 1)
                                                {{ substr($phone->type->description, 0, 1) }}:
                                            @endif
                                            {{ $phone->number }}<br>
                                        @endforeach
                                    </td>
                                </tr>
                                <tr>
                                    <td colspan="3"><i>{{ $member->pivot->description }}</i></td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                @endif
            @endforeach
            @foreach($lay_chaplains->roleGroups as $group)
                @if($group->roles->count() > 0)
                    <h3 class="sub-heading">{{ $group->name }}</h3>
                    @foreach($group->roles()->orderBy('sort')->get() as $groupRole)
                        @if($groupRole->members()->wherePivot('scope_id', $circuit->id)->count() > 0)
                            <table class="table">
                                <thead>
                                    <tr>
                                        <th colspan="3">{{ $groupRole->name }}</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach($groupRole->members()->wherePivot('scope_id', $circuit->id)->orderBy('last_name')->get() as $member)
                                        <tr>
                                            <td width="30%">{{ $member->name }}</td>
                                            <td>
                                                @if($member->primary_email)
                                                    {{ $member->primary_email->address }}
                                                @endif
                                            </td>
                                            <td width="20%">
                                                @foreach($member->phones as $phone)
                                                    @if($loop->count > 1)
                                                        {{ substr($phone->type->description, 0, 1) }}:
                                                    @endif
                                                    {{ $phone->number }}<br>
                                                @endforeach
                                            </td>
                                        </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        @endif
                    @endforeach
                @endif
            @endforeach
            <div class="footer"></div>
        </div>
        <div class="page">
            <script type="text/php">$GLOBALS['chapters']['7'] = $pdf->get_page_number();</script>
            <h2 class="heading">{{ $local_preachers->name }}</h2>
            <p>A * by the date a preacher was accredited means that they are not available to take appointments.</p>
            @foreach($local_preachers->roles()->orderBy('sort')->get() as $role)
                @if($role->members()->wherePivot('scope_id', $circuit->id)->count() > 0)
                    <h3 class="sub-heading">{{ $role->name }}</h3>
                    <table class="table">
                        <tbody>
                            @foreach($role->members()->wherePivot('scope_id', $circuit->id)->orderBy('last_name')->get() as $member)
                                <tr class="flush-bottom">
                                    <td width="30%">{{ $member->name }}</td>
                                    <td>
                                        @if($member->primary_email)
                                            {{ $member->primary_email->address }}
                                        @endif
                                    </td>
                                    <td width="20%">
                                        @foreach($member->phones as $phone)
                                            @if($loop->count > 1)
                                                {{ substr($phone->type->description, 0, 1) }}:
                                            @endif
                                            {{ $phone->number }}<br>
                                        @endforeach
                                    </td>
                                </tr>
                                <tr>
                                    <td colspan="3">{{ $member->pivot->description }}</td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                @endif
            @endforeach
            @foreach($local_preachers->roleGroups as $group)
                @if($group->roles->count() > 0)
                    <h3 class="sub-heading">{{ $group->name }}</h3>
                    @foreach($group->roles()->orderBy('sort')->get() as $groupRole)
                        @if($groupRole->members()->wherePivot('scope_id', $circuit->id)->count() > 0)
                            <table class="table">
                                <tbody>
                                    @foreach($groupRole->members()->wherePivot('scope_id', $circuit->id)->orderBy('last_name')->get() as $member)
                                        <tr class="flush-bottom">
                                            <td width="30%">{{ $member->name }}</td>
                                            <td>
                                                @if($member->primary_email)
                                                    {{ $member->primary_email->address }}
                                                @endif
                                            </td>
                                            <td width="20%">
                                                @foreach($member->phones as $phone)
                                                    @if($loop->count > 1)
                                                        {{ substr($phone->type->description, 0, 1) }}:
                                                    @endif
                                                    {{ $phone->number }}<br>
                                                @endforeach
                                            </td>
                                        </tr>
                                        <tr>
                                            <td class="text-italic">{{ $groupRole->name }}</td>
                                            <td colspan="2">{{ $member->pivot->description }}</td>
                                        </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        @endif
                    @endforeach
                @endif
            @endforeach
            <div class="footer"></div>
        </div>
        <div class="page">
            <script type="text/php">$GLOBALS['chapters']['8'] = $pdf->get_page_number();</script>
            <h2 class="heading">{{ $circuit->district->name }} Contacts</h2>
            <p class="sub-heading">Website: {{ $circuit->district->website }}</p>
            @foreach($district_roles as $role)
                @if($role->members()->wherePivot('scope_id', $circuit->district->id)->count() > 0)
                    <table class="table">
                        <thead>
                            <tr>
                                <th colspan="3">{{ $role->name }}</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($role->members()->wherePivot('scope_id', $circuit->district->id)->orderBy('last_name')->get() as $member)
                                <tr>
                                    <td width="30%">{{ $member->name }}</td>
                                    <td>
                                        @if($member->primary_email)
                                            {{ $member->primary_email->address }}
                                        @endif
                                    </td>
                                    <td width="20%">
                                        @foreach($member->phones as $phone)
                                            @if($loop->count > 1)
                                                {{ substr($phone->type->description, 0, 1) }}:
                                            @endif
                                            {{ $phone->number }}<br>
                                        @endforeach
                                    </td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                @endif
            @endforeach
            <div class="footer"></div>
        </div>
        <div class="page">
            <script type="text/php">$GLOBALS['chapters']['9'] = $pdf->get_page_number();</script>
            <h2 class="heading">{{ $queens->name }} Contacts</h2>
            <p>
                Somerset Road, Edgbaston, Birmingham, B15 2QH<br>
                0121 454 1527
            </p>
            @foreach($queens_members as $name => $members)
                {{--@if($role->members()->wherePivot('scope_id', $queens->id)->count() > 0)--}}
                    <table class="table">
                        <thead>
                            <tr>
                                <th colspan="3">{{ $name }}</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($members as $member)
                                <tr>
                                    <td width="30%">{{ $member->name }}</td>
                                    <td>
                                        @if($member->primary_email)
                                            {{ $member->primary_email->address }}
                                        @endif
                                    </td>
                                    <td width="20%">
                                        @foreach($member->phones as $phone)
                                            @if($loop->count > 1)
                                                {{ substr($phone->type->description, 0, 1) }}:
                                            @endif
                                            {{ $phone->number }}<br>
                                        @endforeach
                                    </td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                {{--@endif--}}
            @endforeach
            <div class="footer"></div>
        </div>
        <div class="page">
            <script type="text/php">$GLOBALS['chapters']['10'] = $pdf->get_page_number();</script>
            <h2 class="heading">Churches</h2>
            @foreach($circuit->churches as $church)
                <h3 class="sub-heading">{{ $church->name }}</h3>
                <table class="table">
                    <tbody>
                        <tr>
                            <td colspan="2">
                                @if($church->address)
                                    {{ $church->address->full_address }}<br>
                                @endif
                                @if($church->link)
                                    {{ $church->link }}<br>
                                @endif
                                @if($church->email)
                                    {{ $church->email->address }}
                                @endif
                            </td>
                            <td width="20%">
                                @if($church->phone)
                                    {{ $church->phone->number }}<br>
                                @endif
                                @if($church->membership_count)
                                    Members: {{ $church->membership_count }}<br>
                                @endif
                                @if($church->ccli_number)
                                    CCLI: {{ $church->ccli_number }}
                                @endif
                            </td>
                        </tr>
                        <?php $prevRole = $role->name; ?>
                        @foreach($church->roles->groupBy('name') as $name => $roles)
                            @if($roles->count() > 1)
                                <tr class="flush-bottom">
                            @else
                                <tr>
                            @endif
                                <td width="30%">{{ $name }}</td>
                                <td>{{ $roles->first()->pivot->member->name }}</td>
                                <td width="20%">
                                    @foreach($roles->first()->pivot->member->phones as $phone)
                                        @if($loop->count > 1)
                                            {{ substr($phone->type->description, 0, 1) }}:
                                        @endif
                                        {{ $phone->number }}<br>
                                    @endforeach
                                </td>
                            </tr>
                            @foreach($roles->take(-($roles->count() - 1)) as $role)
                                @if($loop->last)
                                    <tr>
                                @else
                                    <tr class="flush-bottom">
                                @endif
                                    <td width="30%"></td>
                                    <td>{{ $role->pivot->member->name }}</td>
                                    <td width="20%">
                                        @foreach($role->pivot->member->phones as $phone)
                                            @if($loop->count > 1)
                                                {{ substr($phone->type->description, 0, 1) }}:
                                            @endif
                                            {{ $phone->number }}<br>
                                        @endforeach
                                    </td>
                                </tr>
                            @endforeach
                        @endforeach
                    </tbody>
                </table>
            @endforeach
            <div class="footer"></div>
        </div>
        <div class="page">
            <script type="text/php">$GLOBALS['chapters']['11'] = $pdf->get_page_number();</script>
            <h2 class="heading">A-Z Index of all Birmingham Circuit Contacts</h2>
            <table class="table">
                <thead>
                    <tr>
                        <th width="30%">Name</th>
                        <th>Email/Address</th>
                        <th width="20%">Phone</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach($circuit->members as $member)
                        <tr>
                            <td>{{ $member->name }}</td>
                            <td>
                                @if($member->primary_email)
                                    {{ $member->primary_email->address }}<br>
                                @endif
                                @if($member->primary_address)
                                    {{ $member->primary_address->full_address }}
                                @endif
                            </td>
                            <td>
                                @foreach($member->phones as $phone)
                                    @if($loop->count > 1)
                                        {{ substr($phone->type->description, 0, 1) }}:
                                    @endif
                                    {{ $phone->number }}<br>
                                @endforeach
                            </td>
                        </tr>
                    @endforeach
                </tbody>
            </table>
            <div class="footer"></div>
        </div>
        <div class="page page--preface">
            <h2 class="heading">Circuit Directory</h2>
            <p>If there are changes or corrections, please notify me as soon as possible.</p>
            <p>
                <em>Thank You, Sue Saunderson</em><br>
                email: <strong>ssaunderson@birminghammethodistcircuit.org.uk</strong>
            </p>
            <h3 class="sub-heading">Data Protection</h3>
            <p>
                <strong>Protecting Data:</strong>
                We take the protection data in this directory very seriously and so we ask that
                individuals and churches using this directory comply with the following:
            </p>
            <ol>
                <li>
                    Copies of the Circuit Directory should not be left lying in public places and should be stored
                    where only those permitted (church leadership or the individual who has been given it) to the
                    information can access it.
                </li>
                <li>
                    Contact details within the Circuit Directory should only be given to those people for whom it is
                    necessary for the running of a church or circuit. If in doubt about this, please contact the
                    Circuit Office on 0121 616 1800 or contact@birminghammethodistcircuit.org.uk.
                </li>
            </ol>
            <p>
                <strong>Your Data:</strong>
                People have a right to request that details of their name, address and telephone
                number are not included in this directory. Those providing information for inclusion in the Directory
                (if you’re in a church this is usually your Church Council Secretary) are asked to ensure that the
                people concerned are aware of this right. It is helpful for us to have your details so we can send all
                of our church and circuit leaders information quickly and easily as outlined below.
            </p>
            <p>
                <strong>What is the Circuit Directory for?</strong>
                This Directory is intended only for the purposes of enabling
                effective communication between officers and members of the churches in the Circuit in relation to
                church business. The Directory should not be used for any other purpose or be passed to any
                person or organisation outside the Circuit without the written permission of one of our three
                Superintendent Ministers.<br>
                <strong>Permission will only be given in exceptional circumstances.</strong>
            </p>
            <div class="footer"></div>
        </div>
        <script type="text/php">
            foreach ($GLOBALS['chapters'] as $chapter => $page) {
                $pdf->get_cpdf()->objects[$GLOBALS['backside']]['c'] = str_replace( '%%CH'.$chapter.'%%' , $page , $pdf->get_cpdf()->objects[$GLOBALS['backside']]['c'] );
            }
            $pdf->page_script('
                if ($PAGE_NUM==1 ) {
                    $pdf->add_object($GLOBALS["backside"],"add");
                    $pdf->stop_object($GLOBALS["backside"]);
                }
            ');
        </script>
        <script type="text/php">
            if (isset($pdf)) {
                $pdf->page_script('
                    $font = $fontMetrics->get_font(\'Helvetica, Arial, sans-serif\', \'normal\');
                    $pageText = $PAGE_NUM;
                    $y = 760;
                    $x = 300;
                    $size = 12;
                    $pdf->text($x, $y, $pageText, $font, $size);
                ');
            }
        </script>
    </body>
</html>
