@extends('app')

@section('title')
    <h2>
        {{ $role->name }}
        <a class="btn btn-default pull-right" href="{{ route('roles.show', ['id' => $role->id]) }}">
            <i class="fa fa-eye"></i>
            View Role
        </a>
    </h2>
@stop

@section('breadcrumbs')
    <ol class="breadcrumb breadcrumb-plain flush-bottom">
        <li><a href="/"><i class="fa fa-home visible-xs"></i> <span class="hidden-xs">Dashboard</span></a></li>
        <li><a href="{{ route('roles.index') }}">Roles</a></li>
        <li class="active">{{ $role->name }}</li>
    </ol>
@stop

@section('content')
    <div class="panel panel-default">
        <div class="panel-heading">Role Details</div>
        <div class="panel-body">
            @include('directory::roles.panels.role-details')
        </div>
    </div>
@endsection