<?php namespace DistrictHub\Directory\Gateways;

use DistrictHub\Contracts\Gateways\Directory\CircuitGateway as CircuitGatewayContract;
use DistrictHub\Directory\Gateways\Gateway;
use DistrictHub\Directory\Circuit;

/**
 * CircuitGateway.
 *
 * @author       Tom Densham <tom.densham@studiobonito.co.uk>
 * @copyright    Studio Bonito Ltd.
 * @package      App\Gateways\Directory
 */
class CircuitGateway extends Gateway implements CircuitGatewayContract
{
    /**
     * @var string FQCN of model.
     */
    protected $model = Circuit::class;

    /**
     * Search records with fields and sort with order.
     *
     * @param array $fields
     * @param array $order
     *
     * @return \Illuminate\Database\Eloquent\Collection|static[]
     */
    public function search(array $fields, array $order)
    {
        // Start query
        $circuits = $this->model()->query();

        // Searching
        foreach ($fields as $field => $value) {
            if (!empty($value)) {
                if ($field === 'number') {
                    $circuits = $circuits->where($field, $value);
                } else {
                    $circuits = $circuits->where($field, 'like', "%$value%");
                }
            }
        }

        // Ordering
        if (!empty($order)) {
            foreach ($order as $orderBy) {
                $circuits = $circuits->orderBy($orderBy['column'], $orderBy['dir']);
            }
        }

        // Get query results
        return $circuits->get();
    }

    /**
     * Get the total number of records.
     *
     * @return int
     */
    public function total()
    {
        return $this->model()->count();
    }

    /**
     * Find a model by its primary key.
     *
     * @param  mixed $id
     *
     * @return \DistrictHub\Directory\Circuit|null
     */
    public function find($id)
    {
        return $this->model()->find($id);
    }

    /**
     * Update a model with the specified primary key.
     *
     * @param int   $id
     * @param array $attributes
     *
     * @return bool
     */
    public function update($id, array $attributes)
    {
        $model = $this->model()->find($id)->fill($attributes);

        if ($model->save()) {
            return true;
        }

        return false;
    }

    /**
     * Get array of ids/values for use in select fields.
     *
     * @param string $valueColumn
     * @param string $idColumn
     * @param string $default
     *
     * @return array
     */
    public function options($valueColumn, $idColumn = 'id', $default = '-- Select --')
    {
        return [null => $default] + $this->model()->all()->pluck($valueColumn, $idColumn)->toArray();
    }
}
