<?php namespace DistrictHub\Directory\Gateways;

use DistrictHub\Contracts\Gateways\Directory\MemberTypeGateway as MemberTypeGatewayContract;
use DistrictHub\Directory\Gateways\Gateway;
use DistrictHub\Directory\MemberType;

/**
 * MemberTypeGateway.
 *
 * @author       Tom Densham <tom.densham@studiobonito.co.uk>
 * @copyright    Studio Bonito Ltd.
 * @package      App\Gateways\Directory
 */
class MemberTypeGateway extends Gateway implements MemberTypeGatewayContract
{
    /**
     * @var string FQCN of model.
     */
    protected $model = MemberType::class;

    /**
     * Get array of ids/values for use in select fields.
     *
     * @param string $valueColumn
     * @param string $idColumn
     * @param string $default
     *
     * @return array
     */
    public function options($valueColumn, $idColumn = 'id', $default = '-- Select --')
    {
        return [null => $default] + $this->model()->all()->pluck($valueColumn, $idColumn)->toArray();
    }
}
