<?php

namespace DistrictHub\Directory\Http\Controllers;

use App\Http\Controllers\Controller;
use DistrictHub\Directory\Circuit;
use DistrictHub\Directory\Directory;
use Dompdf\Dompdf;
use Dompdf\Options;
use Illuminate\Http\Request;

class CircuitDirectoryController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Circuit $circuit)
    {
        return view('directory::circuits.directory.index', compact('circuit'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request $request
     *
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     *
     * @param  \DistrictHub`Directory\PrintedDirectory  $printedDirectory
     *
     * @return \Illuminate\Http\Response
     */
    public function show(Directory $printedDirectory)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \DistrictHub`Directory\PrintedDirectory  $printedDirectory
     *
     * @return \Illuminate\Http\Response
     */
    public function edit(Directory $printedDirectory)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request $request
     * @param  \DistrictHub`Directory\PrintedDirectory  $printedDirectory
     *
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, Directory $printedDirectory)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \DistrictHub`Directory\PrintedDirectory  $printedDirectory
     *
     * @return \Illuminate\Http\Response
     */
    public function destroy(Directory $printedDirectory)
    {
        //
    }

    public function print($circuitId)
    {
        $circuit = Circuit::with([
            'district',
            'roleGroups.roles',
            'members.addresses',
            'members.phones',
            'members.emails',
        ])->find($circuitId);

        $superintendents = $this->getMembersForRole($circuit, 34);

        $safeguarding = $circuit->district->roles()->where('role_id', 16)->get()->map(function ($item) {
            return $item->pivot->member;
        })->sortBy('last_name');

        $circuit_officers = $circuit->roleGroups->find(1);

        $forum_contacts = $circuit->roleGroups->find(2);

        $ministers = $circuit->roleGroups->find(6);

        $circuit_staff = $circuit->roleGroups->find(11);

        $lay_chaplains = $circuit->roleGroups->find(15);

        $local_preachers = $circuit->roleGroups->find(16);

        $district_roles = $circuit->district->roles()->whereIn('directory_roles.id', [2, 18, 6, 14, 16, 5, 4])->get();

        $queens = Circuit::find(13);

        $queens_members = $queens->roles()->orderBy('sort')->get()->groupBy('name')->map(function ($group) {
            return $group->map(function ($role) {
                return $role->pivot->member;
            })->sortBy('last_name');
        });

        $data = compact(
            'circuit',
            'superintendents',
            'safeguarding',
            'circuit_officers',
            'forum_contacts',
            'ministers',
            'circuit_staff',
            'lay_chaplains',
            'local_preachers',
            'district_roles',
            'queens',
            'queens_members'
        );

//        return view('directory::circuits.directory.print', $data);

        $filename = 'directory.pdf';
        return response($this->pdf($data), 200, [
            'Content-Description' => 'File Transfer',
            'Content-Disposition' => 'attachment; filename="'.$filename.'"',
            'Content-Transfer-Encoding' => 'binary',
            'Content-Type' => 'application/pdf',
        ]);
    }

    private function getMembersForRole(&$circuit, $roleId)
    {
        return $circuit->roles()->where('role_id', $roleId)->get()->map(function ($item) {
            return $item->pivot->member;
        })->sortBy('last_name');
    }

    private function pdf(array $data)
    {
        if (! defined('DOMPDF_ENABLE_AUTOLOAD')) {
            define('DOMPDF_ENABLE_AUTOLOAD', false);
        }
        if (file_exists($configPath = base_path().'/vendor/dompdf/dompdf/dompdf_config.inc.php')) {
            require_once $configPath;
        }
        $options = new Options;
        $options->set('isPhpEnabled', true);
        $dompdf = new Dompdf($options);
        $dompdf->loadHtml(view('directory::circuits.directory.print', $data)->render());
        $dompdf->render();
        return $dompdf->output();
    }
}
