<?php namespace DistrictHub\Directory\Http\Controllers;

use DistrictHub\Directory\Church;
use DistrictHub\Directory\Member;
use DistrictHub\Directory\Phone;
use DistrictHub\Directory\PhoneTitle;
use DistrictHub\Directory\PhoneType;
use App\Http\Controllers\Controller;
use DistrictHub\Directory\Http\Requests;
use Illuminate\Http\Request;
use Laracasts\Flash\Flash;

class PhoneController extends Controller
{
    /*
    |--------------------------------------------------------------------------
    | Directory Phone Controller
    |--------------------------------------------------------------------------
    */

    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('auth');
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return Response
     */
    public function create(Request $request)
    {
        $memberId = $request->route()->parameter('member');
        $churchId = $request->route()->parameter('church');

        if (!is_null($memberId)) {
            $owner = Member::find($memberId);
        }

        if (!is_null($churchId)) {
            $owner = Church::find($churchId);
        }

        $types = PhoneType::all()->pluck('description', 'id');

        return view('directory::phones.create', compact('types', 'owner'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @return Response
     */
    public function store(Requests\PhoneRequest $request)
    {
        $phone = Phone::create($request->all());

        $memberId = $request->route()->parameter('member');
        $churchId = $request->route()->parameter('church');

        if (!is_null($memberId)) {
            $member = Member::find($memberId);
            $member->phones()->save($phone);
        }

        if (!is_null($churchId)) {
            $church = Church::find($churchId);
            $church->phone()->save($phone);
        }

        Flash::success("Created Phone \"{$phone->number}\"");

        return redirect()->back();
    }

    /**
     * Display the specified resource.
     *
     * @param  int $id
     *
     * @return Response
     */
    public function show(Request $request)
    {
        $phoneId = $request->route()->parameter('email');

        $phone = Phone::find($phoneId);

        return view('directory::phones.show', compact('phone'));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @return Response
     */
    public function edit(Request $request)
    {
        $phoneId = $request->route()->parameter('phone');

        $phone = Phone::find($phoneId);

        $memberId = $request->route()->parameter('member');
        $churchId = $request->route()->parameter('church');

        if (!is_null($memberId)) {
            $owner = Member::find($memberId);
        }

        if (!is_null($churchId)) {
            $owner = Church::find($churchId);
        }

        $types = PhoneType::all()->pluck('description', 'id');

        return view('directory::phones.edit', compact('phone', 'types', 'owner'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @return Response
     */
    public function update(Requests\PhoneRequest $request)
    {
        $phoneId = $request->route()->parameter('phone');

        $phone = Phone::find($phoneId);

        $phone->update($request->all());

        Flash::success("Updated Phone \"{$phone->number}\"");

        return redirect()->back();
    }

    /**
     * Show delete confirmation.
     *
     * @return Response
     */
    public function delete($memberId, $phoneId)
    {
        return view('directory::phones.delete', compact('memberId', 'phoneId'));
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int $id
     *
     * @return Response
     */
    public function destroy($memberId, $phoneId)
    {
        $phone = Phone::find($phoneId);

        Phone::destroy($phoneId);

        Flash::success("Deleted Phone \"{$phone->number}\"");

        return redirect()->back();
    }
}
