<?php namespace DistrictHub\Directory\Jobs;

use DistrictHub\Contracts\Gateways\Directory\RoleGateway;
use DistrictHub\Directory\Events\RoleWasUpdated;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;

class UpdateRole
{
    use SerializesModels;

    protected $id;

    protected $attributes;

    /**
     * Create a new command instance.
     *
     * @param       $id
     * @param array $attributes
     *
     * @return void
     */
    public function __construct($id, array $attributes)
    {
        $this->id = $id;
        $this->attributes = $attributes;
    }

    /**
     * Execute the command.
     *
     * @return void
     */
    public function handle(RoleGateway $roleGateway)
    {
        if ($roleGateway->update($this->id, $this->attributes)) {
            $role = $roleGateway->find($this->id);
            event(new RoleWasUpdated($role));
        }
    }
}
