<?php namespace DistrictHub\Directory\Listeners;

use DistrictHub\Directory\Events\ChurchLinkedToMember;
use DistrictHub\Support\Listeners\Notification;

class AlertChurchLinkedToMember extends Notification
{
    /**
     * Handle the event.
     *
     * @param  ChurchLinkedToMember $event
     *
     * @return void
     */
    public function handle(ChurchLinkedToMember $event)
    {
        $this->notifier->success("Linked Church \"{$event->church->name}\" to Member \"{$event->member->name}\"");
    }
}
