<?php namespace DistrictHub\Directory\Events;

use DistrictHub\Directory\Member;
use DistrictHub\Directory\Role;
use Illuminate\Broadcasting\InteractsWithSockets;
use Illuminate\Foundation\Events\Dispatchable;
use Illuminate\Queue\SerializesModels;

class MemberRemovedFromRole
{
    use Dispatchable, InteractsWithSockets, SerializesModels;

    /**
     * @var Member
     */
    public $member;

    /**
     * @var Role
     */
    public $role;

    /**
     * Create a new event instance.
     *
     * @param Member $member
     * @param Role   $role
     */
    public function __construct(Member $member, Role $role)
    {
        $this->member = $member;
        $this->role = $role;
    }
}
