<?php

namespace DistrictHub\Directory\Http\Controllers;

use App\Http\Controllers\Controller;
use DistrictHub\Directory\Role;
use DistrictHub\Directory\RoleGroup;
use Illuminate\Http\Request;

class CircuitRolesController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index($circuitId, RoleGroup $roleGroup)
    {
        $roles = Role::circuit()->orderBy('sort')->get();

        $assigned = $roleGroup->roles;

        $assignedIds = $assigned->pluck('id')->toArray();

        $available = array_values($roles->filter(function (Role $role) use ($assignedIds) {
            return !in_array($role->id, $assignedIds);
        })->toArray());

        return response()->json(compact('assigned', 'available'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store($circuitId, RoleGroup $roleGroup, $roleId)
    {

    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Role  $role
     * @return \Illuminate\Http\Response
     */
    public function show(Role $role)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Role  $role
     * @return \Illuminate\Http\Response
     */
    public function edit(Role $role)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Role  $role
     * @return \Illuminate\Http\Response
     */
    public function update($circuitId, RoleGroup $roleGroup, $roleId)
    {
        $roleGroup->roles()->attach($roleId);
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Role  $role
     * @return \Illuminate\Http\Response
     */
    public function destroy($circuitId, RoleGroup $roleGroup, $roleId)
    {
        $roleGroup->roles()->detach($roleId);
    }
}
