<?php namespace DistrictHub\Directory\Http\Controllers;

use DistrictHub\Directory\GdprRecord;
use DistrictHub\Directory\Http\Requests\GdprRequest;
use DistrictHub\Directory\Member;
use Illuminate\Routing\Controller;

class MemberGdprController extends Controller
{
    /**
     * MemberGdprController constructor.
     */
    public function __construct()
    {
        $this->middleware('auth');
    }

    /**
     * Display a listing of the resource.
     *
     * @param \DistrictHub\Directory\Member $member
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Member $member)
    {
        //
    }

    /**
     * Show the form for creating a new resource.
     *
     * @param \DistrictHub\Directory\Member $member
     *
     * @return \Illuminate\Http\Response
     */
    public function create(Member $member)
    {
        return view('directory::gdpr.create', compact('member'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param \DistrictHub\Directory\Http\Requests\GdprRequest $request
     * @param \DistrictHub\Directory\Member                    $member
     *
     * @return \Illuminate\Http\Response
     */
    public function store(GdprRequest $request, Member $member)
    {
        $record = new GdprRecord($request->only('authorized_at', 'details'));

        $record->member()->associate($member);

        $record->user()->associate($request->user());

        $record->save();

        return redirect()->route('members.show', $member);
    }

    /**
     * Display the specified resource.
     *
     * @param \DistrictHub\Directory\Member     $member
     * @param \DistrictHub\Directory\GdprRecord $gdprRecord
     *
     * @return \Illuminate\Http\Response
     */
    public function show(Member $member, GdprRecord $gdprRecord)
    {
        //
    }
}
