@extends('app')

@section('title')
    <h2>Assign Roles</h2>
@stop

@section('breadcrumbs')
    <ol class="breadcrumb breadcrumb-plain flush-bottom">
        <li><a href="/"><i class="fa fa-home visible-xs"></i> <span class="hidden-xs">Dashboard</span></a></li>
        <li><a href="{{ route('circuits.index') }}">Circuits</a></li>
        <li><a href="{{ route('circuits.show', $circuit->id) }}">{{ $circuit->name }}</a></li>
        <li><a href="{{ route('circuits.role-groups.index', $circuit->id) }}">Role Groups</a></li>
        <li class="active">{{ $roleGroup->name }}</li>
    </ol>
@stop

@section('content')
    <role-picker src="{{ route('circuits.role-groups.roles.index', [$circuit->id, $roleGroup->id]) }}"></role-picker>
@endsection

@section('scripts')
    <script type="text/javascript" src="{{ mix('js/app.js') }}"></script>
@stop
