@if($member->gdpr_authorized_at && $member->gdpr_authorized_at->addMonths(12)->lessThan(Carbon\Carbon::now()))
    <div class="alert alert-warning">
        <div class="media">
            <div class="media-body media-middle">
                <strong>Warning!</strong>
                This member gave consent more than {{ $member->gdpr_authorized_at->diffForHumans() }}.
            </div>
            <div class="media-right">
                <a href="{{ route('members.gdpr.create', $member) }}" class="btn btn-warning pull-right">Update consent</a>
            </div>
        </div>
    </div>
@elseif(!$member->gdpr_authorized_at)
    <div class="alert alert-warning">
        <div class="media">
            <div class="media-body media-middle">
                <strong>Warning!</strong>
                This member has not given consent for you to hold their information.
            </div>
            <div class="media-right">
                <a href="{{ route('members.gdpr.create', $member) }}" class="btn btn-warning pull-right">Update consent</a>
            </div>
        </div>
    </div>
@endif
