<?php namespace DistrictHub\Directory\Jobs;

use DistrictHub\Contracts\Gateways\Directory\MemberGateway;
use DistrictHub\Directory\Events\MemberWasUpdated;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;

class UpdateMember
{
    use SerializesModels;

    protected $id;

    protected $attributes;

    /**
     * Create a new command instance.
     *
     * @param int   $id
     * @param array $attributes
     *
     * @return void
     */
    public function __construct($id, array $attributes)
    {
        $this->id = $id;
        $this->attributes = $attributes;
    }

    /**
     * Execute the command.
     *
     * @return void
     */
    public function handle(MemberGateway $memberGateway)
    {
        if ($memberGateway->update($this->id, $this->attributes)) {
            $member = $memberGateway->find($this->id);
            event(new MemberWasUpdated($member));
        }
    }
}
