@extends('app')

@section('title')
    <h2>
        {{ $circuit->name }}
        @if(Auth::user()->ability('district-admin', 'edit-circuit'))
            <div class="btn-group pull-right">
                <a class="btn btn-default" href="{{ route('circuits.show', ['id' => $circuit->id]) }}">
                    <i class="fa fa-eye"></i>
                    View Circuit
                </a>
                <button type="button" class="btn btn-default dropdown-toggle" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                    <span class="caret"></span>
                    <span class="sr-only">Toggle Dropdown</span>
                </button>
                <ul class="dropdown-menu">
                    <li>
                        <a href="{{ route('circuits.role-groups.index', $circuit->id) }}">
                            <i class="fa fa-group"></i>
                            Edit Roles
                        </a>
                    </li>
                    <li>
                        <a href="{{ route('circuits.directory.print', [$circuit->id, 1]) }}">
                            <i class="fa fa-print"></i>
                            Print Directory
                        </a>
                    </li>
                </ul>
            </div>
        @else
            <a class="btn btn-default pull-right" href="{{ route('circuits.show', ['id' => $circuit->id]) }}">
                <i class="fa fa-eye"></i>
                View Circuit
            </a>
        @endif
    </h2>
@stop

@section('breadcrumbs')
    <ol class="breadcrumb breadcrumb-plain flush-bottom">
        <li><a href="/"><i class="fa fa-home visible-xs"></i> <span class="hidden-xs">Dashboard</span></a></li>
        <li><a href="{{ route('circuits.index') }}">Circuits</a></li>
        <li class="active">{{ $circuit->name }}</li>
    </ol>
@stop

@section('content')
    <div class="panel panel-default">
        <div class="panel-heading">Circuit Details</div>

        <div class="panel-body">

            {!! Form::model($circuit, ['method' => 'PATCH', 'route' => ['circuits.update', $circuit->id]]) !!}

            @include('directory::circuits.fields.defaults', ['submitButtonText' => 'Update'])

            {!! Form::close() !!}
        </div>
    </div>
@endsection
