{!! Form::model($member, ['method' => 'PATCH', 'route' => ['members.churches.link', $member->id]]) !!}
<div class="row">
    <div class="col-lg-5">
        <div class="input-group {{ $errors->has('church_id') ? 'has-error' : '' }}">
            {!! Form::text('church_id', null, ['id' => 'church_id', 'class' => 'form-control', 'placeholder' => 'Search for church...']) !!}
            <span class="input-group-btn">
                {!! Form::button('Link Church', ['class' => 'btn btn-default', 'type' => 'submit']) !!}
            </span>
        </div>
        @if($errors->has('member_id'))
            <span class="text-danger">{{ $errors->first('member_id') }}</span>
        @endif
    </div>
</div>
{!! Form::close() !!}

<div class="table-responsive">
    <table class="table table table-striped display" cellspacing="0" width="100%">
        <thead>
            <tr>
                <th>Name</th>
                <th>Circuit</th>
                <th>Last Updated</th>
                <th></th>
            </tr>
        </thead>

        @foreach($member->churches as $church)
            <tr>
                <td>{{ $church->name }}</td>
                <td>{{ $church->circuit->name }}</td>
                <td>{{ $church->updated_at }}</td>
                <td data-display="{{ $church->id }}">
                    <a href="{{ route('churches.show', [$church->id]) }}">show</a> |
                    <a href="{{ route('churches.edit', [$church->id]) }}">edit</a> |
                    <a href="{{ route('members.churches.unlink', [$member->id, $church->id]) }}">unlink</a>
                </td>
            </tr>
        @endforeach
    </table>
</div>