<div class="table-responsive">
    <table class="table table table-striped display" cellspacing="0" width="100%">
        <thead>
            <tr>
                <th>Role</th>
                <th>District</th>
                <th>Last Updated</th>
                @if(Auth::user()->ability('district-admin', 'edit-role'))
                    <th></th>
                @endif
            </tr>
        </thead>

        @foreach($member->district_roles as $role)
            <tr>
                <td>{{ $role->name }}</td>
                <td>{{ $role->pivot->scope->name }}</td>
                <td>{{ $role->pivot->updated_at }}</td>
                @if(Auth::user()->ability('district-admin', 'edit-role'))
                    <td data-display="{{ $role->pivot->id }}">
                        <a class="btn btn-default btn-xs"
                           href="{{ route('members.roles.remove', ['members' => $member->id, 'roles' => $role->id, 'scope_id' => $role->pivot->scope_id, 'scope_type' => $role->pivot->scope_type]) }}"
                           data-toggle="tooltip" data-placement="top" title="Remove role">
                            <i class="fa fa-trash"></i>
                        </a>
                    </td>
                @endif
            </tr>
        @endforeach
    </table>
</div>

@if(Auth::user()->ability('district-admin', 'edit-role'))
    {!! Form::open(['method' => 'PATCH', 'route' => ['members.roles.assign', $member->id]]) !!}
    @include('directory::members.fields.district-roles')
    {!! Form::close() !!}
@endif