<div class="table-responsive">
    <table class="table table table-striped display" cellspacing="0" width="100%">
        <thead>
            <tr>
                <th>Address</th>
                <th>Type</th>
                <th>Primary</th>
                <th>Last Updated</th>
                <th></th>
            </tr>
        </thead>

        @foreach($member->emails as $email)
            <tr>
                <td>{{ $email->address }}</td>
                <td>{{ $email->type->description }}</td>
                <td>
                    @if($email->primary)
                        <span class="glyphicon glyphicon-ok text-success" aria-hidden="true"></span>
                    @endif
                </td>
                <td>{{ $email->updated_at }}</td>
                <td data-display="{{ $email->id }}">
                    <a class="btn btn-default btn-xs"
                       href="{{ route('members.emails.show', [$member->id, $email->id]) }}" data-toggle="modal"
                       data-target="#modal">
                        <i class="fa fa-eye" data-toggle="tooltip" data-placement="top" title="View email address"></i>
                    </a>
                    <a class="btn btn-default btn-xs"
                       href="{{ route('members.emails.edit', [$member->id, $email->id]) }}" data-toggle="modal"
                       data-target="#modal">
                        <i class="fa fa-pencil" data-toggle="tooltip" data-placement="top"
                           title="Edit email address"></i>
                    </a>
                    <a class="btn btn-default btn-xs"
                       href="{{ route('members.emails.delete', [$member->id, $email->id]) }}" data-toggle="modal"
                       data-target="#modal">
                        <i class="fa fa-trash" data-toggle="tooltip" data-placement="top"
                           title="Delete email address"></i>
                    </a>
                </td>
            </tr>
        @endforeach
    </table>
</div>
<a class="btn btn-default" href="{{ route('members.emails.create', [$member->id]) }}" data-toggle="modal"
   data-target="#modal">Add Email</a>