@extends('app')

@section('title')
    <h2>
        Roles
        @if(Auth::user()->ability('district-admin', 'create-role'))
            <a class="btn btn-default pull-right" href="{{ route('roles.create') }}">
                <i class="fa fa-plus-circle"></i>
                Add Role
            </a>
        @endif
    </h2>
@stop

@section('breadcrumbs')
    <ol class="breadcrumb breadcrumb-plain flush-bottom">
        <li><a href="/"><i class="fa fa-home visible-xs"></i> <span class="hidden-xs">Dashboard</span></a></li>
        <li class="active">Roles</li>
    </ol>
@stop

@section('content')
    <div class="panel panel-default">
        <div class="panel-heading">Roles</div>
        <div role="tabpanel">
            <!-- Nav tabs -->
            <ul class="nav nav-tabs" role="tablist">
                <li role="presentation" class="active">
                    <a href="#district-roles" aria-controls="district-roles" role="tab" data-toggle="tab">
                        District
                        <span class="badge">{{ $district->count() }}</span></a>
                </li>
                <li role="presentation">
                    <a href="#circuit-roles" aria-controls="circuit-roles" role="tab" data-toggle="tab">
                        Circuit
                        <span class="badge">{{ $circuit->count() }}</span>
                    </a>
                </li>
                <li role="presentation">
                    <a href="#church-roles" aria-controls="church-roles" role="tab" data-toggle="tab">
                        Church
                        <span class="badge">{{ $church->count() }}</span>
                    </a>
                </li>
            </ul>
            <!-- Tab panes -->
            <div class="tab-content">
                <div role="tabpanel" class="tab-pane active" id="district-roles">
                    <role-list scope="district" src="{{ route('roles.index') }}"></role-list>
                </div>
                <div role="tabpanel" class="tab-pane" id="circuit-roles">
                    <role-list scope="circuit" src="{{ route('roles.index') }}"></role-list>
                </div>
                <div role="tabpanel" class="tab-pane" id="church-roles">
                    <role-list scope="church" src="{{ route('roles.index') }}"></role-list>
                </div>
            </div>
        </div>
    </div>
@endsection

@section('scripts')
    <script type="text/javascript" src="{{ mix('js/app.js') }}"></script>
@stop
