<?php namespace DistrictHub\Directory\Jobs;

use DistrictHub\Contracts\Gateways\Directory\MemberGateway;
use DistrictHub\Directory\Role;
use DistrictHub\Directory\Events\MemberAssignedToRole;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;

class AssignMemberToRole
{
    use SerializesModels;

    /**
     * @var
     */
    private $memberId;

    /**
     * @var
     */
    private $roleId;

    /**
     * @var
     */
    private $scopeId;

    /**
     * @var
     */
    private $scopeType;

    /**
     * @var
     */
    private $description;

    /**
     * Create a new command instance.
     *
     * @param $memberId
     * @param $roleId
     * @param $scopeId
     * @param $scopeType
     * @param $description
     */
    public function __construct($memberId, $roleId, $scopeId, $scopeType, $description)
    {
        $this->memberId = $memberId;
        $this->roleId = $roleId;
        $this->scopeId = $scopeId;
        $this->scopeType = $scopeType;
        $this->description = $description;
    }

    /**
     * Execute the command.
     *
     * @param MemberGateway $members
     */
    public function handle(MemberGateway $members)
    {
        $member = $members->find($this->memberId);

        $role = Role::find($this->roleId);

        $member->roles()->save($role, [
            'scope_id'    => $this->scopeId,
            'scope_type'  => $this->scopeType,
            'description' => $this->description,
        ]);

        event(new MemberAssignedToRole($member, $role));
    }
}
