<?php namespace DistrictHub\Directory\Jobs;

use DistrictHub\Contracts\Gateways\Directory\ChurchGateway;
use DistrictHub\Contracts\Gateways\Directory\MemberGateway;
use DistrictHub\Directory\Events\ChurchLinkedToMember;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;

class LinkChurchToMember
{
    use SerializesModels;

    /**
     * @var int
     */
    private $churchId;

    /**
     * @var int
     */
    private $memberId;

    /**
     * Create a new command instance.
     *
     * @param int $churchId
     * @param int $memberId
     */
    public function __construct($churchId, $memberId)
    {
        $this->churchId = $churchId;
        $this->memberId = $memberId;
    }

    /**
     * Execute the command.
     *
     * @return void
     */
    public function handle(ChurchGateway $churches, MemberGateway $members)
    {
        $member = $members->find($this->memberId);

        $church = $churches->find($this->churchId);

        $member->churches()->save($church);

        event(new ChurchLinkedToMember($church, $member));
    }
}
