<?php namespace DistrictHub\Directory\Listeners;

use DistrictHub\Directory\Events\CircuitWasCreated;
use DistrictHub\Support\Listeners\Notification;

class AlertCircuitCreated extends Notification
{
    /**
     * Handle the event.
     *
     * @param  CircuitWasCreated $event
     *
     * @return void
     */
    public function handle(CircuitWasCreated $event)
    {
        $url = route('circuits.edit', [$event->circuit->id]);
        $this->notifier->success("Created Circuit \"<a href=\"{$url}\">{$event->circuit->name}</a>\"");
    }
}
