<?php namespace DistrictHub\Directory;

use Illuminate\Database\Eloquent\Model;

class Phone extends Model
{
    /**
     * Format the updated_at property.
     */
    use TimestampFormat;

    /**
     * The database table used by the model.
     *
     * @var string
     */
    protected $table = 'directory_phones';

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
        'number',
        'primary',
        'type_id',
    ];

    /**
     * The attributes excluded from the model's JSON form.
     *
     * @var array
     */
    protected $hidden = [
        'type_id',
        'owner_id',
        'owner_type',
    ];

    /**
     * Scope a query to return the primary record.
     *
     * @param $query
     *
     * @return mixed
     */
    public function scopePrimary($query)
    {
        return $query->where('primary', true);
    }

    /**
     * The related PhoneType model.
     *
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function type()
    {
        return $this->belongsTo(PhoneType::class);
    }

    /**
     * The related owner model.
     *
     * @return \Illuminate\Database\Eloquent\Relations\MorphTo
     */
    public function owner()
    {
        return $this->morphTo();
    }
}
