<?php namespace DistrictHub\Directory\Gateways;

use DistrictHub\Contracts\Gateways\Directory\ChurchGateway as ChurchGatewayContract;
use DistrictHub\Directory\Gateways\Gateway;
use DistrictHub\Directory\Church;

/**
 * ChurchGateway.
 *
 * @author       Tom Densham <tom.densham@studiobonito.co.uk>
 * @copyright    Studio Bonito Ltd.
 * @package      App\Gateways\Directory
 */
class ChurchGateway extends Gateway implements ChurchGatewayContract
{
    /**
     * @var string FQCN of model.
     */
    protected $model = Church::class;

    /**
     * Search records with fields and sort with order.
     *
     * @param array $fields
     * @param array $order
     *
     * @return \Illuminate\Database\Eloquent\Collection|static[]
     */
    public function search(array $fields, array $order)
    {
        // Start query
        $churches = $this->model()->select('directory_churches.*')
                         ->leftJoin(
                             'directory_circuits as circuit',
                             'directory_churches.circuit_id',
                             '=',
                             'circuit.id'
                         );

        // Hack to specify name
        if (isset($fields['name'])) {
            $fields['directory_churches.name'] = $fields['name'];
            unset($fields['name']);
        }

        // Searching
        foreach ($fields as $field => $value) {
            if (!empty($value)) {
                if (ends_with($field, '_id')) {
                    $churches = $churches->where($field, $value);
                } else {
                    $churches = $churches->where($field, 'like', "%$value%");
                }
            }
        }

        // Ordering
        if (!empty($order)) {
            foreach ($order as $orderBy) {
                $churches = $churches->orderBy($orderBy['column'], $orderBy['dir']);
            }
        }

        // Get query results
        return $churches->with('circuit')->get();
    }

    /**
     * Get the total number of records.
     *
     * @return int
     */
    public function total()
    {
        return $this->model()->count();
    }

    /**
     * Find a model by its primary key.
     *
     * @param  mixed $id
     *
     * @return \DistrictHub\Directory\Church|null
     */
    public function find($id)
    {
        return $this->model()->find($id);
    }

    /**
     * Update a model with the specified primary key.
     *
     * @param int   $id
     * @param array $attributes
     *
     * @return bool
     */
    public function update($id, array $attributes)
    {
        $model = $this->model()->find($id)->fill($attributes);

        if ($model->save()) {
            return true;
        }

        return false;
    }
}
