<?php namespace DistrictHub\Directory\Listeners;

use DistrictHub\Directory\Events\MemberWasUpdated;
use DistrictHub\Support\Listeners\Notification;

class AlertMemberUpdated extends Notification
{
    /**
     * Handle the event.
     *
     * @param  MemberWasUpdated $event
     *
     * @return void
     */
    public function handle(MemberWasUpdated $event)
    {
        $this->notifier->success("Updated Member \"{$event->member->name}\"");
    }
}
