<?php namespace DistrictHub\Directory;

use Illuminate\Database\Eloquent\Relations\MorphToMany;

class RoleMorphToMany extends MorphToMany
{
    /**
     * Create a new pivot model instance.
     *
     * @param  array $attributes
     * @param  bool  $exists
     *
     * @return \Illuminate\Database\Eloquent\Relations\Pivot
     */
    public function newPivot(array $attributes = [], $exists = false)
    {
        $pivot = new RoleMorphPivot($this->parent, $attributes, $this->table, $exists);

        $pivot->setPivotKeys($this->foreignKey, $this->otherKey)
              ->setMorphType($this->morphType)
              ->setMorphClass($this->morphClass);

        return $pivot;
    }
}
