@extends('app')

@section('title')
    <h2>
        {{ $member->name }}
        <a class="btn btn-default pull-right" href="{{ route('members.show', ['id' => $member->id]) }}">
            <i class="fa fa-eye"></i>
            View Member
        </a>
    </h2>
@stop

@section('breadcrumbs')
    <ol class="breadcrumb breadcrumb-plain flush-bottom">
        <li><a href="/"><i class="fa fa-home visible-xs"></i> <span class="hidden-xs">Dashboard</span></a></li>
        <li><a href="{{ route('members.index') }}">Members</a></li>
        <li class="active">{{ $member->name }}</li>
    </ol>
@stop

@section('content')
    @include('directory::gdpr')

    <div class="panel panel-default">
        <div class="panel-heading">Personal Details</div>
        <div class="panel-body">
            @include('directory::members.panels.personal-details')
        </div>
    </div>

    <div class="panel panel-default">
        <div class="panel-heading">Role Details</div>
        <div class="panel-body">
            @include('directory::members.panels.role-details')
        </div>
    </div>

    <div class="panel panel-default">
        <div class="panel-heading">Contact Details</div>
        <div class="panel-body">
            @include('directory::members.panels.contact-details')
        </div>
    </div>

    {{--<div class="panel panel-default">--}}
    {{--<div class="panel-heading">Group Details</div>--}}
    {{--<div class="panel-body">--}}
    {{--@include('directory::members.panels.group-details')--}}
    {{--</div>--}}
    {{--</div>--}}

    <div class="panel panel-default">
        <div class="panel-heading">Extra Details</div>
        <div class="panel-body">
            @include('directory::members.panels.extra-details')
        </div>
    </div>
@endsection

@section('scripts')
    <script>
        $('#church_id').selectize({
            maxItems: 1,
            valueField: 'id',
            labelField: 'name',
            searchField: 'name',
            sortField: 'name',
            create: false,
            render: {
                option: function (item, escape) {
                    return '<div>' +
                        '<span class="">' + escape(item.name) + '</span><br>' +
                        '<span class="text-muted">' + escape(item.circuit.name) + '</span>' +
                        '</div>';
                },
            },
            load: function (query, callback) {
                if (!query.length) return callback();
                $.ajax({
                    url: '{{ route('api.churches.index') }}',
                    type: 'GET',
                    dataType: 'json',
                    error: function () {
                        callback();
                    },
                    success: function (response) {
                        callback(response.data);
                    },
                });
            },
        });

        $('#districts').selectize({
            maxItems: 1,
            valueField: 'id',
            labelField: 'name',
            searchField: 'name',
            sortField: 'name',
            create: false,
            render: {
                option: function (item, escape) {
                    return '<div>' +
                        '<span class="">' + escape(item.name) + '</span><br>' +
                        '</div>';
                },
            },
            load: function (query, callback) {
                if (!query.length) return callback();
                $.ajax({
                    url: '{{ route('api.districts.index') }}',
                    type: 'GET',
                    dataType: 'json',
                    error: function () {
                        callback();
                    },
                    success: function (response) {
                        callback(response.data);
                    },
                });
            },
        });

        $('#circuits').selectize({
            maxItems: 1,
            valueField: 'id',
            labelField: 'name',
            searchField: 'name',
            sortField: 'name',
            create: false,
            render: {
                option: function (item, escape) {
                    return '<div>' +
                        '<span class="">' + escape(item.name) + '</span><br>' +
                        '</div>';
                },
            },
            load: function (query, callback) {
                if (!query.length) return callback();
                $.ajax({
                    url: '{{ route('api.circuits.index') }}',
                    type: 'GET',
                    dataType: 'json',
                    error: function () {
                        callback();
                    },
                    success: function (response) {
                        callback(response.data);
                    },
                });
            },
        });

        $('#churches').selectize({
            maxItems: 1,
            valueField: 'id',
            labelField: 'name',
            searchField: 'name',
            sortField: 'name',
            create: false,
            render: {
                option: function (item, escape) {
                    return '<div>' +
                        '<span class="">' + escape(item.name) + '</span><br>' +
                        '</div>';
                },
            },
            load: function (query, callback) {
                if (!query.length) return callback();
                $.ajax({
                    url: '{{ route('api.churches.index') }}',
                    type: 'GET',
                    dataType: 'json',
                    error: function () {
                        callback();
                    },
                    success: function (response) {
                        callback(response.data);
                    },
                });
            },
        });

        $('[data-toggle="tooltip"]').tooltip();
    </script>
@stop
