<?php namespace DistrictHub\Directory;

use Illuminate\Database\Eloquent\Model;

class Address extends Model
{
    /**
     * Format the updated_at property.
     */
    use TimestampFormat;

    /**
     * The database table used by the model.
     *
     * @var string
     */
    protected $table = 'directory_addresses';

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
        'address_line1',
        'address_line2',
        'address_line3',
        'city',
        'postcode',
        'primary',
    ];

    /**
     * The attributes excluded from the model's JSON form.
     *
     * @var array
     */
    protected $hidden = [
        'owner_id',
        'owner_type',
    ];

    /**
     * Scope a query to return the primary record.
     *
     * @param $query
     *
     * @return mixed
     */
    public function scopePrimary($query)
    {
        return $query->where('primary', true);
    }

    /**
     * The related owner model.
     *
     * @return \Illuminate\Database\Eloquent\Relations\MorphTo
     */
    public function owner()
    {
        return $this->morphTo();
    }

    /**
     * The full address attribute.
     *
     * @return string
     */
    public function getFullAddressAttribute()
    {
        $pieces = [
            $this->address_line1,
            $this->address_line2,
            $this->address_line3,
            $this->city,
            $this->postcode,
        ];

        return implode(', ', array_filter($pieces));
    }
}
