<?php namespace DistrictHub\Directory\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Support\Facades\Auth;

class GdprRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return Auth::check();
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'authorized_at' => 'required|date',
            'details'       => 'required',
        ];
    }

    /**
     * Get the error messages for the defined validation rules.
     *
     * @return array
     */
    public function messages()
    {
        return [
            'authorized_at.required' => 'The date field is required',
            'authorized_at.date'     => 'The date is not a valid date',
            'details.required'       => 'The nature of authority given field is required',
        ];
    }
}
