<?php namespace DistrictHub\Directory\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Support\Facades\Auth;

class MemberRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return Auth::check();
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'first_name' => 'required_with:last_name',
            'last_name'  => 'required_with:first_name',
            'type_id'    => 'required_with:circuit_id',
            'circuit_id' => 'required_with:type_id',
        ];
    }
}
