<?php namespace DistrictHub\Directory;

use Illuminate\Database\Eloquent\Model;

class Email extends Model
{
    /**
     * Format the updated_at property.
     */
    use TimestampFormat;

    /**
     * The database table used by the model.
     *
     * @var string
     */
    protected $table = 'directory_emails';

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
        'address',
        'primary',
        'type_id',
    ];

    /**
     * The attributes excluded from the model's JSON form.
     *
     * @var array
     */
    protected $hidden = [
        'type_id',
        'owner_id',
        'owner_type',
    ];

    /**
     * Scope a query to return the primary record.
     *
     * @param $query
     *
     * @return mixed
     */
    public function scopePrimary($query)
    {
        return $query->where('primary', true);
    }

    /**
     * The related EmailType model.
     *
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function type()
    {
        return $this->belongsTo(EmailType::class);
    }

    /**
     * The related owner model.
     *
     * @return \Illuminate\Database\Eloquent\Relations\MorphTo
     */
    public function owner()
    {
        return $this->morphTo();
    }
}
