<div class="table-responsive">
    <table class="table table table-striped display" cellspacing="0" width="100%">
        <thead>
            <tr>
                <th>Number</th>
                <th>Type</th>
                <th>Primary</th>
                <th>Last Updated</th>
                <th></th>
            </tr>
        </thead>

        @foreach($member->phones as $phone)
            <tr>
                <td>{{ $phone->number }}</td>
                <td>{{ $phone->type->description }}</td>
                <td>
                    @if($phone->primary)
                        <span class="glyphicon glyphicon-ok text-success" aria-hidden="true"></span>
                    @endif
                </td>
                <td>{{ $phone->updated_at }}</td>
                <td data-display="{{ $phone->id }}">
                    <a class="btn btn-default btn-xs"
                       href="{{ route('members.phones.show', [$member->id, $phone->id]) }}" data-toggle="modal"
                       data-target="#modal">
                        <i class="fa fa-eye" data-toggle="tooltip" data-placement="top" title="View phone number"></i>
                    </a>
                    <a class="btn btn-default btn-xs"
                       href="{{ route('members.phones.edit', [$member->id, $phone->id]) }}" data-toggle="modal"
                       data-target="#modal">
                        <i class="fa fa-pencil" data-toggle="tooltip" data-placement="top"
                           title="Edit phone number"></i>
                    </a>
                    <a class="btn btn-default btn-xs"
                       href="{{ route('members.phones.delete', [$member->id, $phone->id]) }}" data-toggle="modal"
                       data-target="#modal">
                        <i class="fa fa-trash" data-toggle="tooltip" data-placement="top"
                           title="Delete phone number"></i>
                    </a>
                </td>
            </tr>
        @endforeach
    </table>
</div>
<a class="btn btn-default" href="{{ route('members.phones.create', [$member->id]) }}" data-toggle="modal"
   data-target="#modal">Add Phone</a>