<?php namespace DistrictHub\Directory;

class Activity extends \Spatie\Activitylog\Models\Activity
{
    public static function boot()
    {
        parent::boot();

        static::creating(function (self $model) {
            $model->subject_name = $model->subject->name;

            $id = $model->subject->id;

            $hasRole = MemberRole::where('member_id', $id)->where('scope_type', District::class)->count() > 0;

            $isInGroup = \DistrictHub\Groups\Group::whereHas('members', function ($query) use ($id) {
                $query->where('member_id', $id);
            })->count() > 0;

            if ($hasRole || $isInGroup) {
                $model->district_id = District::first()->id;
            }

            $model->circuit_id = $model->subject->circuit_id;
        });
    }
}
