<?php namespace DistrictHub\Directory\Gateways;

use DistrictHub\Contracts\Gateways\Directory\MemberTitleGateway as MemberTitleGatewayContract;
use DistrictHub\Directory\Gateways\Gateway;
use DistrictHub\Directory\MemberTitle;

/**
 * MemberTitleGateway.
 *
 * @author       Tom Densham <tom.densham@studiobonito.co.uk>
 * @copyright    Studio Bonito Ltd.
 * @package      App\Gateways\Directory
 */
class MemberTitleGateway extends Gateway implements MemberTitleGatewayContract
{
    /**
     * @var string FQCN of model.
     */
    protected $model = MemberTitle::class;

    /**
     * Get array of ids/values for use in select fields.
     *
     * @param string $valueColumn
     * @param string $idColumn
     * @param string $default
     *
     * @return array
     */
    public function options($valueColumn, $idColumn = 'id', $default = '-- Select --')
    {
        return [null => $default] + $this->model()->all()->pluck($valueColumn, $idColumn)->toArray();
    }
}
