<?php

namespace DistrictHub\Directory\Http\Controllers;

use App\Http\Controllers\Controller;
use DistrictHub\Directory\Circuit;
use DistrictHub\Directory\RoleGroup;
use Illuminate\Http\Request;

class CircuitRoleGroupsController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Circuit $circuit)
    {
        if (request()->ajax()) {
            $groups = RoleGroup::circuit($circuit)->topLevel()->with('roleGroups')->ordered()->get();
            return response()->json(compact('groups'));
        }

        return view('directory::circuits.role-groups.index', compact('circuit'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create(Circuit $circuit)
    {
        $groups = RoleGroup::circuit($circuit)->topLevel()->ordered()->pluck('name', 'id');

        $groups->prepend('(None)', 0);

        $parentId = request('parentId');

        return view('directory::circuits.role-groups.create', compact('circuit', 'groups', 'parentId'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request $request
     *
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request, Circuit $circuit)
    {
        $circuit->roleGroups()->create($request->only('name', 'parent_id'));

        return redirect()->route('circuits.role-groups.index', $circuit->id);
    }

    /**
     * Display the specified resource.
     *
     * @param  int $id
     *
     * @return \Illuminate\Http\Response
     */
    public function show(Circuit $circuit, RoleGroup $roleGroup)
    {
        return view('directory::circuits.role-groups.show', compact('circuit', 'roleGroup'));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int $id
     *
     * @return \Illuminate\Http\Response
     */
    public function edit(Circuit $circuit, RoleGroup $roleGroup)
    {
        $groups = RoleGroup::circuit($circuit)->topLevel()->ordered()->pluck('name', 'id');

        $groups->prepend('(None)', 0);

        return view('directory::circuits.role-groups.edit', compact('circuit', 'groups', 'roleGroup'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request $request
     * @param  int                      $id
     *
     * @return \Illuminate\Http\Response
     */
    public function update(Circuit $circuit, RoleGroup $roleGroup)
    {
        $roleGroup->update(request()->only(['name', 'parent_id']));

        return redirect()->route('circuits.role-groups.index', $roleGroup->scope_id);
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int $id
     *
     * @return \Illuminate\Http\Response
     */
    public function destroy($circuitId, RoleGroup $roleGroup)
    {
        $roleGroup->delete();
    }

    public function sort()
    {
        RoleGroup::setNewOrder(request('order'));
    }
}
