<?php

namespace DistrictHub\Directory\Http\Controllers;

use DistrictHub\Directory\District;
use App\Http\Controllers\Controller;
use DistrictHub\Directory\Http\Requests\DistrictRequest;
use Laracasts\Flash\Flash;

class DistrictController extends Controller
{
    use ExportsCsv;

    /**
     * Create a new controller instance.
     */
    public function __construct()
    {
        $this->middleware('auth');
    }

    /**
     * Display a listing of the resource.
     *
     * @return Response
     */
    public function index()
    {
        //
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @return Response
     */
    public function store()
    {
        //
    }

    /**
     * Display the specified resource.
     *
     * @param  int $id
     *
     * @return Response
     */
    public function show($id)
    {
        $district = District::findOrFail($id);

        return view('directory::districts.show', compact('district'));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int $id
     *
     * @return Response
     */
    public function edit($id)
    {
        $district = District::findOrFail($id);

        return view('directory::districts.edit', compact('district'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  int                                                 $id
     * @param \DistrictHub\Directory\Http\Requests\DistrictRequest $request
     *
     * @return \DistrictHub\Directory\Http\Controllers\Response
     */
    public function update($id, DistrictRequest $request)
    {
        $district = District::findOrFail($id);

        $district->update($request->only(['name', 'number', 'charity_number', 'website']));

        Flash::success("Updated District \"{$district->name}\"");

        return redirect()->back();
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int $id
     *
     * @return Response
     */
    public function destroy($id)
    {
        //
    }
}
