<?php namespace DistrictHub\Directory\Jobs;

use DistrictHub\Directory\Role;
use DistrictHub\Directory\Events\RoleWasCreated;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;

class CreateRole
{
    use SerializesModels;

    private $attributes;

    /**
     * Create a new command instance.
     *
     * @param array $attributes
     */
    public function __construct(array $attributes)
    {
        $this->attributes = $attributes;
    }

    /**
     * Execute the command.
     *
     * @return void
     */
    public function handle()
    {
        $role = Role::create($this->attributes);

        event(new RoleWasCreated($role));
    }
}
