<?php namespace DistrictHub\Directory\Jobs;

use DistrictHub\Contracts\Gateways\Directory\MemberGateway;
use DistrictHub\Directory\Role;
use DistrictHub\Directory\Events\MemberRemovedFromRole;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;

class RemoveMemberFromRole
{
    use SerializesModels;

    /**
     * @var
     */
    private $memberId;

    /**
     * @var
     */
    private $roleId;

    /**
     * @var
     */
    private $scopeId;

    /**
     * @var
     */
    private $scopeType;

    /**
     * Create a new command instance.
     *
     * @param $memberId
     * @param $roleId
     */
    public function __construct($memberId, $roleId, $scopeId, $scopeType)
    {
        $this->memberId = $memberId;
        $this->roleId = $roleId;
        $this->scopeId = $scopeId;
        $this->scopeType = $scopeType;
    }

    /**
     * Execute the command.
     *
     * @param MemberGateway $members
     */
    public function handle(MemberGateway $members)
    {
        $member = $members->find($this->memberId);

        $role = Role::find($this->roleId);

        $member->roles()
               ->wherePivot('scope_id', $this->scopeId)
               ->wherePivot('scope_type', $this->scopeType)
               ->detach($this->roleId);

        $scope = $this->scopeType::find($this->scopeId);

        $member->logActivity('updated', [
            'attributes' => ['role.name' => ''],
            'old'        => ['role.name' => "{$role->name} ({$scope->name} [$role->scope_name])"],
        ]);

        event(new MemberRemovedFromRole($member, $role));
    }
}
