<?php namespace DistrictHub\Directory\Listeners;

use DistrictHub\Directory\Events\RoleWasCreated;

use DistrictHub\Support\Listeners\Notification;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Contracts\Queue\ShouldBeQueued;

class AlertRoleCreated extends Notification
{
    /**
     * Handle the event.
     *
     * @param  RoleWasCreated $event
     *
     * @return void
     */
    public function handle(RoleWasCreated $event)
    {
        $this->notifier->success("Created Role \"{$event->role->name}\"");
    }
}
