@extends('app')

@section('title')
    <h2>Edit Role Group</h2>
@stop

@section('breadcrumbs')
    <ol class="breadcrumb breadcrumb-plain flush-bottom">
        <li><a href="/"><i class="fa fa-home visible-xs"></i> <span class="hidden-xs">Dashboard</span></a></li>
        <li><a href="{{ route('circuits.index') }}">Circuits</a></li>
        <li><a href="{{ route('circuits.show', $circuit->id) }}">{{ $circuit->name }}</a></li>
        <li><a href="{{ route('circuits.role-groups.index', $circuit->id) }}">Role Groups</a></li>
        <li class="active">{{ $roleGroup->name }}</li>
    </ol>
@stop

@section('content')
    <div class="panel panel-default">
        <div class="panel-heading">Role Group</div>

        <div class="panel-body">

            {!! Form::open(['method' => 'PUT', 'route' => ['circuits.role-groups.update', $circuit->id, $roleGroup->id]]) !!}

            <div class="form-group{{ $errors->has('name') ? ' has-error' : '' }}">
                {!! Form::label('name', 'Name', ['class' => 'control-label']) !!}
                {!! Form::text('name', $roleGroup->name, ['class' => 'form-control', 'autofocus' => 'autofocus']) !!}
                @if($errors->has('name'))
                    <span class="text-danger">{{ $errors->first('name') }}</span>
                @endif
            </div>

            <div class="form-group{{ $errors->has('parent_id') ? ' has-error' : '' }}">
                {!! Form::label('parent_id', 'Parent Role Group') !!}
                {!! Form::select('parent_id', $groups, $roleGroup->parent_id, ['class' => 'form-control']) !!}
                @if($errors->has('parent_id'))
                    <span class="text-danger">{{ $errors->first('parent_id') }}</span>
                @endif
            </div>

            {!! Form::button('Update', ['class' => 'btn btn-primary', 'type' => 'submit']) !!}

            {!! Form::close() !!}
        </div>
    </div>
@endsection
