@extends('app')

@section('title')
    <h2>
        {{ $circuit->name }}
        @if(Auth::user()->ability('district-admin', 'edit-circuit'))
            <div class="btn-group pull-right">
                <a class="btn btn-default" href="{{ route('circuits.edit', ['id' => $circuit->id]) }}">
                    <i class="fa fa-pencil"></i>
                    Edit Circuit
                </a>
                <button type="button" class="btn btn-default dropdown-toggle" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                    <span class="caret"></span>
                    <span class="sr-only">Toggle Dropdown</span>
                </button>
                <ul class="dropdown-menu">
                    <li>
                        <a href="{{ route('circuits.role-groups.index', $circuit->id) }}">
                            <i class="fa fa-group"></i>
                            Edit Roles
                        </a>
                    </li>
                    <li>
                        <a href="{{ route('circuits.directory.print', [$circuit->id, 1]) }}">
                            <i class="fa fa-print"></i>
                            Print Directory
                        </a>
                    </li>
                </ul>
            </div>
        @endif
    </h2>
@stop

@section('breadcrumbs')
    <ol class="breadcrumb breadcrumb-plain flush-bottom">
        <li><a href="/"><i class="fa fa-home visible-xs"></i> <span class="hidden-xs">Dashboard</span></a></li>
        <li><a href="{{ route('circuits.index') }}">Circuits</a></li>
        <li class="active">{{ $circuit->name }}</li>
    </ol>
@stop

@section('content')
    <div class="row">
        <div class="col-lg-6">
            <h3>Circuit Details</h3>
            <dl class="dl-horizontal">
                <dt>Name</dt>
                <dd>{{ $circuit->district->number }}/{{ $circuit->number }} {{ $circuit->name }}</dd>
                @if($circuit->charity_number)
                    <dt>Charity number</dt>
                    <dd>{{ $circuit->charity_number }}</dd>
                @endif
                @if($circuit->website)
                    <dt>Website</dt>
                    <dd>
                        <a href="{{ $circuit->website }}" target="_blank">{{ $circuit->website }}</a>
                        <span class="glyphicon glyphicon-new-window"></span>
                    </dd>
                @endif
            </dl>
        </div>
        @if($circuit->roles->count() > 0)
            @if($circuit->roleGroups->count() > 0)
                <div class="col-lg-12">
                    <h3>Circuit Roles</h3>
                    <div class="panel-group" id="role-groups" role="tablist" aria-multiselectable="true">
                        @foreach($circuit->roleGroups()->topLevel()->get() as $group)
                            <div class="panel panel-roles">
                                <div class="panel-heading" role="tab" id="heading-{{ str_slug($group->name) }}">
                                    <h4 class="panel-title">
                                        <i class="fa fa-plus-circle"></i>
                                        <a role="button" data-toggle="collapse" data-parent="#role-groups"
                                           href="#collapse-{{ str_slug($group->name) }}-{{ $group->id }}" aria-expanded="false"
                                           aria-controls="collapse-{{ str_slug($group->name) }}">
                                            {{ $group->name }}
                                        </a>
                                    </h4>
                                </div>
                                <div id="collapse-{{ str_slug($group->name) }}-{{ $group->id }}" class="panel-collapse collapse" role="tabpanel"
                                     aria-labelledby="heading-{{ str_slug($group->name) }}">
                                    <div class="panel-body">
                                        <div class="panel-group" id="roles" role="tablist" aria-multiselectable="true">
                                            @foreach($group->roles()->orderBy('sort')->get()->groupBy('name') as $name => $roles)
                                                @if($roles->sum(function($role) use($circuit) {return $role->members()->wherePivot('scope_id', $circuit->id)->count();}) > 0)
                                                    <div class="panel panel-roles">
                                                        <div class="panel-heading" role="tab" id="heading-{{ str_slug($name) }}-{{ $group->id }}">
                                                            <h4 class="panel-title">
                                                                <i class="fa fa-plus-circle"></i>
                                                                <a role="button" data-toggle="collapse" data-parent="#roles"
                                                                   href="#collapse-{{ str_slug($name) }}-{{ $group->id }}" aria-expanded="false"
                                                                   aria-controls="collapse-{{ str_slug($name) }}-{{ $group->id }}">
                                                                    {{ $name }}
                                                                </a>
                                                                ({{ $roles->sum(function($role) use($circuit) {return $role->members()->wherePivot('scope_id', $circuit->id)->count();}) }})
                                                            </h4>
                                                        </div>
                                                        <div id="collapse-{{ str_slug($name) }}-{{ $group->id }}" class="panel-collapse collapse" role="tabpanel"
                                                             aria-labelledby="heading-{{ str_slug($name) }}-{{ $group->id }}">
                                                            <div class="panel-body">
                                                                <div class="row">
                                                                    @foreach($roles as $role)
                                                                        @foreach($role->members()->wherePivot('scope_id', $circuit->id)->orderBy('last_name')->get()->chunk(ceil($role->members()->wherePivot('scope_id', $circuit->id)->count() / 4)) as $chunk)
                                                                            <div class="col-lg-3">
                                                                                <ul>
                                                                                    @foreach($chunk as $member)
                                                                                        <li>
                                                                                            <a href="{{ url('members', $member->id) }}">{{ $member->name }}</a>
                                                                                        </li>
                                                                                    @endforeach
                                                                                </ul>
                                                                            </div>
                                                                        @endforeach
                                                                    @endforeach
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                @endif
                                            @endforeach
                                                <div class="panel-group" id="role-sub-groups" role="tablist" aria-multiselectable="true">
                                                    @foreach($group->roleGroups as $group)
                                                        <div class="panel panel-roles">
                                                            <div class="panel-heading" role="tab" id="heading-{{ str_slug($group->name) }}-{{ $group->id }}">
                                                                <h4 class="panel-title">
                                                                    <i class="fa fa-plus-circle"></i>
                                                                    <a role="button" data-toggle="collapse" data-parent="#role-sub-groups"
                                                                       href="#collapse-{{ str_slug($group->name) }}-{{ $group->id }}" aria-expanded="false"
                                                                       aria-controls="collapse-{{ str_slug($group->name) }}-{{ $group->id }}">
                                                                        {{ $group->name }}
                                                                    </a>
                                                                </h4>
                                                            </div>
                                                            <div id="collapse-{{ str_slug($group->name) }}-{{ $group->id }}" class="panel-collapse collapse" role="tabpanel"
                                                                 aria-labelledby="heading-{{ str_slug($group->name) }}-{{ $group->id }}">
                                                                <div class="panel-body">
                                                                    <div class="panel-group" id="roles" role="tablist" aria-multiselectable="true">
                                                                        @foreach($group->roles->groupBy('name') as $name => $roles)
                                                                            @if($roles->sum(function($role) use($circuit) {return $role->members()->wherePivot('scope_id', $circuit->id)->count();}) > 0)
                                                                                <div class="panel panel-roles">
                                                                                    <div class="panel-heading" role="tab" id="heading-{{ str_slug($name) }}-{{ $group->id }}">
                                                                                        <h4 class="panel-title">
                                                                                            <i class="fa fa-plus-circle"></i>
                                                                                            <a role="button" data-toggle="collapse" data-parent="#roles"
                                                                                               href="#collapse-{{ str_slug($name) }}-{{ $group->id }}" aria-expanded="false"
                                                                                               aria-controls="collapse-{{ str_slug($name) }}-{{ $group->id }}">
                                                                                                {{ $name }}
                                                                                            </a>
                                                                                            ({{ $roles->sum(function($role) use($circuit) {return $role->members()->wherePivot('scope_id', $circuit->id)->count();}) }})
                                                                                        </h4>
                                                                                    </div>
                                                                                    <div id="collapse-{{ str_slug($name) }}-{{ $group->id }}" class="panel-collapse collapse" role="tabpanel"
                                                                                         aria-labelledby="heading-{{ str_slug($name) }}-{{ $group->id }}">
                                                                                        <div class="panel-body">
                                                                                            <div class="row">
                                                                                                @foreach($roles as $role)
                                                                                                    @foreach($role->members()->wherePivot('scope_id', $circuit->id)->get()->chunk(ceil($role->members()->wherePivot('scope_id', $circuit->id)->count() / 4)) as $chunk)
                                                                                                        <div class="col-lg-3">
                                                                                                            <ul>
                                                                                                                @foreach($chunk as $member)
                                                                                                                    <li>
                                                                                                                        <a href="{{ url('members', $member->id) }}">{{ $member->name }}</a>
                                                                                                                    </li>
                                                                                                                @endforeach
                                                                                                            </ul>
                                                                                                        </div>
                                                                                                    @endforeach
                                                                                                @endforeach
                                                                                            </div>
                                                                                        </div>
                                                                                    </div>
                                                                                </div>
                                                                            @endif
                                                                        @endforeach
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    @endforeach
                                                </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        @endforeach
                    </div>
                </div>
            @else
                <div class="col-lg-12">
                    <h3>Circuit Roles</h3>
                    <div class="panel-group" id="accordion" role="tablist" aria-multiselectable="true">
                        @foreach($circuit->roles->groupBy('name') as $name => $roles)
                            <div class="panel panel-roles">
                                <div class="panel-heading" role="tab" id="heading-{{ str_slug($name) }}">
                                    <h4 class="panel-title">
                                        <a role="button" data-toggle="collapse" data-parent="#accordion"
                                           href="#collapse-{{ str_slug($name) }}" aria-expanded="false"
                                           aria-controls="collapse-{{ str_slug($name) }}">{{ $name }}</a>
                                        ({{ $roles->Count() }})
                                    </h4>
                                </div>
                                <div id="collapse-{{ str_slug($name) }}" class="panel-collapse collapse" role="tabpanel"
                                     aria-labelledby="heading-{{ str_slug($name) }}">
                                    <div class="panel-body">
                                        <div class="row">
                                            @foreach($roles->chunk(ceil($roles->count() / 4)) as $chunk)
                                                <div class="col-lg-3">
                                                    <ul>
                                                        @foreach($chunk as $role)
                                                            <li>
                                                                <a href="{{ url('members', $role->pivot->member->id) }}">{{ $role->pivot->member->name }}</a>
                                                            </li>
                                                        @endforeach
                                                    </ul>
                                                </div>
                                            @endforeach
                                        </div>
                                    </div>
                                </div>
                            </div>
                        @endforeach
                    </div>
                </div>
            @endif
        @endif
        <div class="col-lg-12">
            <h3>List of Churches</h3>
            <div class="row">
                @foreach($circuit->churches as $church)
                    <div class="col-sm-6 col-md-4 col-lg-3">
                        <div class="panel panel-primary">
                            <div class="panel-body">
                                <img class="img-rounded" width="100%" src="{{ $church->picture->url('medium') }}"
                                     alt="{{ $church->name }}">
                            </div>

                            <div class="panel-footer">
                                <h4>{{ $church->name }}</h4>
                                <p>
                                    <a href="{{ route('churches.show', $church->id) }}" class="btn btn-primary"
                                       role="button">
                                        <i class="fa fa-eye"></i>
                                        View
                                    </a>
                                    @if(Auth::user()->ability('district-admin', 'edit-church'))
                                        <a href="{{ route('churches.edit', $church->id) }}" class="btn btn-default"
                                           role="button">
                                            <i class="fa fa-pencil"></i>
                                            Edit
                                        </a>
                                    @endif
                                </p>
                            </div>
                        </div>
                    </div>
                @endforeach
            </div>
        </div>
    </div>
@endsection

@section('scripts')
    <script>
        $('.col-md-4').matchHeight();
    </script>
@stop
