@extends('app')

@section('title')
    <h2>
        {{ $member->name }}
    </h2>
@stop

@section('breadcrumbs')
    <ol class="breadcrumb breadcrumb-plain flush-bottom">
        <li><a href="/"><i class="fa fa-home visible-xs"></i> <span class="hidden-xs">Dashboard</span></a></li>
        <li><a href="{{ route('members.index') }}">Members</a></li>
        <li><a href="{{ route('members.show', $member) }}">{{ $member->name }}</a></li>
        <li class="active">GDPR</li>
    </ol>
@stop

@section('content')
    <div class="panel panel-default">
        <div class="panel-heading">GDPR Record</div>
        <div class="panel-body">
            {!! Form::model($member, ['method' => 'POST', 'route' => ['members.gdpr.store', $member]]) !!}

            <div class="row">
                <div class="col-md-4">
                    <div class="form-group{{ $errors->has('authorized_at') ? ' has-error' : '' }}">
                        {!! Form::label('authorized_at', 'Date', ['class' => 'control-label']) !!}
                        {!! Form::text('authorized_at', \Carbon\Carbon::now()->format('Y-m-d'), ['class' => 'form-control']) !!}
                        <span class="help-block">
                            Date last authority to hold personal data given.
                        </span>
                        @if($errors->has('authorized_at'))
                            <span class="text-danger">{{ $errors->first('authorized_at') }}</span>
                        @endif
                    </div>
                </div>
                <div class="col-md-8">
                    <div class="form-group{{ $errors->has('details') ? ' has-error' : '' }}">
                        {!! Form::label('details', 'Nature of authority given', ['class' => 'control-label']) !!}
                        {!! Form::text('details', null, ['class' => 'form-control', 'autofocus']) !!}
                        @if($errors->has('details'))
                            <span class="text-danger">{{ $errors->first('details') }}</span>
                        @endif
                    </div>
                </div>
            </div>

            {!! Form::button('Update', ['class' => 'btn btn-primary', 'type' => 'submit']) !!}

            {!! Form::close() !!}
        </div>
    </div>
@stop
