<?php namespace DistrictHub\Directory\Gateways;

use DistrictHub\Contracts\Gateways\Directory\ChurchGateway as ChurchGatewayContract;
use DistrictHub\Directory\Gateways\CachedGateway;
use Illuminate\Contracts\Cache\Repository as Cache;

/**
 * CachedChurchGateway.
 *
 * @author       Tom Densham <tom.densham@studiobonito.co.uk>
 * @copyright    Studio Bonito Ltd.
 * @package      App\Gateways\Directory
 */
class CachedChurchGateway extends CachedGateway implements ChurchGatewayContract
{
    /**
     * @var ChurchGateway
     */
    private $gateway;

    /**
     * Create new gateway instance.
     *
     * @param ChurchGateway $gateway
     * @param Cache         $cache
     *
     */
    public function __construct(ChurchGateway $gateway, Cache $cache)
    {
        parent::__construct($cache);
        $this->gateway = $gateway;
    }

    /**
     * Search records with fields and sort with order.
     *
     * @param array $fields
     * @param array $order
     *
     * @return \Illuminate\Database\Eloquent\Collection|static[]
     */
    public function search(array $fields, array $order)
    {
        return $this->remember(
            $this->cacheKey(__METHOD__, func_get_args()),
            function () use ($fields, $order) {
                return $this->gateway->search($fields, $order);
            }
        );
    }

    /**
     * Get the total number of records.
     *
     * @return int
     */
    public function total()
    {
        return $this->remember(
            $this->cacheKey(__METHOD__),
            function () {
                return $this->gateway->total();
            }
        );
    }

    /**
     * Find a model by its primary key.
     *
     * @param  mixed $id
     *
     * @return \DistrictHub\Directory\Church|null
     */
    public function find($id)
    {
        return $this->remember(
            $this->cacheKey(__METHOD__, func_get_args()),
            function () use ($id) {
                return $this->gateway->find($id);
            }
        );
    }

    /**
     * Update a model with the specified primary key.
     *
     * @param int   $id
     * @param array $attributes
     *
     * @return bool
     */
    public function update($id, array $attributes)
    {
        if ($this->gateway->update($id, $attributes)) {
            $this->cache()->flush();

            return true;
        }

        return false;
    }
}
