<?php namespace DistrictHub\Directory\Http\Composers;

use DistrictHub\Directory\Church;
use DistrictHub\Directory\Circuit;
use DistrictHub\Directory\District;
use Illuminate\Contracts\View\View;

/**
 * RolesComposer.
 *
 * @author  Tom Densham <nedmas@mavenfortytwo.co.uk>
 * @package DistrictHub\Directory\Http\Composers
 */
class RolesComposer
{
    public function compose(View $view)
    {
        $roles = [
            District::class => 'District',
            Circuit::class  => 'Circuit',
            Church::class   => 'Church',
        ];
        $view->with('roles', $roles);
    }
}
