<?php namespace DistrictHub\Directory\Providers;

use DistrictHub\Directory\Http\Composers\ChurchComposer;
use DistrictHub\Directory\Http\Composers\ChurchRoleComposer;
use DistrictHub\Directory\Http\Composers\CircuitRoleComposer;
use DistrictHub\Directory\Http\Composers\DistrictRoleComposer;
use DistrictHub\Directory\Http\Composers\MemberComposer;
use DistrictHub\Directory\Http\Composers\RolesComposer;
use Illuminate\Support\Facades\View;
use Illuminate\Support\ServiceProvider;

class ComposerServiceProvider extends ServiceProvider
{
    protected $composers = [
        ChurchComposer::class       => [
            'directory::churches.fields.defaults',
            'directory::churches.fields.search',
        ],
        MemberComposer::class       => [
            'directory::members.fields.defaults',
            'directory::members.fields.search',
        ],
        DistrictRoleComposer::class => [
            'directory::members.fields.district-roles',
        ],
        CircuitRoleComposer::class  => [
            'directory::members.fields.circuit-roles',
        ],
        ChurchRoleComposer::class   => [
            'directory::members.fields.church-roles',
        ],
        RolesComposer::class        => [
            'directory::roles.fields.defaults',
        ],
    ];

    /**
     * Bootstrap the application services.
     *
     * @return void
     */
    public function boot()
    {
        View::composers($this->composers);
    }

    /**
     * Register the application services.
     *
     * @return void
     */
    public function register()
    {
        //
    }
}
