@extends('app')

@section('title')
    <h2>
        {{ $role->name }}
        @if(Auth::user()->ability('district-admin', 'edit-role'))
            <a class="btn btn-default pull-right" href="{{ route('roles.edit', ['id' => $role->id]) }}">
                <i class="fa fa-pencil"></i>
                Edit Role
            </a>
        @endif
    </h2>
@stop

@section('breadcrumbs')
    <ol class="breadcrumb breadcrumb-plain flush-bottom">
        <li><a href="/"><i class="fa fa-home visible-xs"></i> <span class="hidden-xs">Dashboard</span></a></li>
        <li><a href="{{ route('roles.index') }}">Roles</a></li>
        <li class="active">{{ $role->name }}</li>
    </ol>
@stop

@section('content')
    <div class="row">
        <div class="col-lg-6">
            <h3>Role Details</h3>
            <dl class="dl-horizontal">
                <dt>Name</dt>
                <dd>{{ $role->name }}</dd>
                <dt>Scope</dt>
                <dd>{{ $role->scope_name }}</dd>
            </dl>
        </div>
    </div>
@endsection
