<?php namespace DistrictHub\Directory\Listeners;

use DistrictHub\Directory\Events\MemberWasCreated;
use DistrictHub\Support\Listeners\Notification;

class AlertMemberCreated extends Notification
{
    /**
     * Handle the event.
     *
     * @param  MemberWasCreated $event
     *
     * @return void
     */
    public function handle(MemberWasCreated $event)
    {
        $url = route('members.edit', [$event->member->id]);
        $this->notifier->success("Created Member \"<a href=\"{$url}\">{$event->member->name}</a>\"");
    }
}
