@extends('app')

@section('title')
    <h2>
        {{ $member->name }}
        @if(Auth::user()->ability('district-admin', 'edit-member'))
            <a class="btn btn-default pull-right" href="{{ route('members.edit', ['id' => $member->id]) }}">
                <i class="fa fa-pencil"></i>
                Edit Member
            </a>
        @endif
    </h2>
@stop

@section('breadcrumbs')
    <ol class="breadcrumb breadcrumb-plain flush-bottom">
        <li><a href="/"><i class="fa fa-home visible-xs"></i> <span class="hidden-xs">Dashboard</span></a></li>
        <li><a href="{{ route('members.index') }}">Members</a></li>
        <li class="active">{{ $member->name }}</li>
    </ol>
@stop

@section('content')
    @include('directory::gdpr')

    <div class="row">
        <div class="col-lg-6">
            <h3>Personal Details</h3>
            <dl class="dl-horizontal">
                <dt>Title</dt>
                <dd>{{ $member->title }}</dd>
                <dt>First name</dt>
                <dd>{{ $member->first_name }}</dd>
                <dt>Last name</dt>
                <dd>{{ $member->last_name }}</dd>
                <dt>Type</dt>
                <dd>{{ $member->type->description }}</dd>
                <dt>Circuit</dt>
                <dd>{{ $member->circuit->name }}</dd>
            </dl>
            @if($member->church_roles->count() > 0)
                <h3>Church Roles</h3>
                <ul>
                    @foreach($member->church_roles as $role)
                        <li>
                            {{ $role->name }}
                            @if($role->pivot->description)
                            &dash; {{ $role->pivot->description }}
                            @endif
                            (<a href="{{ url('churches', $role->pivot->scope_id) }}">{{ $role->pivot->scope->name }}</a>)
                        </li>
                    @endforeach
                </ul>
            @endif
            @if($member->circuit_roles->count() > 0)
                <h3>Circuit Roles</h3>
                <ul>
                    @foreach($member->circuit_roles as $role)
                        <li>
                            {{ $role->name }}
                            @if($role->pivot->description)
                            &dash; {{ $role->pivot->description }}
                            @endif
                            (<a href="{{ url('circuits', $role->pivot->scope_id) }}">{{ $role->pivot->scope->name }}</a>)
                        </li>
                    @endforeach
                </ul>
            @endif
            @if($member->district_roles->count() > 0)
                <h3>District Roles</h3>
                <ul>
                    @foreach($member->district_roles as $role)
                        <li>
                            {{ $role->name }}
                            @if($role->pivot->description)
                            &dash; {{ $role->pivot->description }}
                            @endif
                            (<a href="{{ url('districts', $role->pivot->scope_id) }}">{{ $role->pivot->scope->name }}</a>)
                        </li>
                    @endforeach
                </ul>
            @endif
            @if($member->groups->count() > 0)
                <h3>Groups</h3>
                <ul>
                    @foreach($member->groups as $group)
                        <li>
                            <a href="{{ route('groups.show', $group->id) }}">{{ $group->name }}</a>
                        </li>
                    @endforeach
                </ul>
            @endif
        </div>
        <div class="col-lg-6">
            <h3>Contact Details</h3>
            @if($member->addresses->count() > 0)
                <h4>Postal addresses</h4>
                <dl class="dl-horizontal">
                    @foreach($member->addresses as $address)
                        <dt>{{ $address->primary ? 'Primary' : 'Other' }}</dt>
                        <dd>
                            @if($address->address_line1)
                                {{ $address->address_line1 }},<br>
                            @endif
                            @if($address->address_line2)
                                {{ $address->address_line2 }},<br>
                            @endif
                            @if($address->address_line3)
                                {{ $address->address_line3 }},<br>
                            @endif
                            @if($address->city)
                                {{ $address->city }},<br>
                            @endif
                            @if($address->postcode)
                                {{ $address->postcode }}
                            @endif
                        </dd>
                    @endforeach
                </dl>
            @endif
            @if($member->phones->count() > 0)
                <h4>Phone numbers</h4>
                <dl class="dl-horizontal">
                    @foreach($member->phones as $phone)
                        <dt>{{ $phone->type->description }}</dt>
                        <dd>
                            <a href="tel:{{ $phone->number }}">{{ $phone->number }}</a>
                            @if($phone->primary)
                                (Primary)
                            @endif
                        </dd>
                    @endforeach
                </dl>
            @endif
            @if($member->emails->count())
                <h4>Email addresses</h4>
                <dl class="dl-horizontal">
                    @foreach($member->emails as $email)
                        <dt>{{ $email->type->description }}</dt>
                        <dd>
                            <a href="mailto:{{ $email->address }}">{{ $email->address }}</a>
                            @if($email->primary)
                                (Primary)
                            @endif
                        </dd>
                    @endforeach
                </dl>
            @endif
        </div>
    </div>
    @if(Auth::user()->ability('district-admin', 'edit-member'))
        @if($member->gdpr()->count() > 0)
            <div class="row">
                <div class="col-lg-12">
                    <h3>GDPR Consent</h3>
                    <p>Authority to hold personal data last given on {{ $member->gdpr_authorized_at->format('jS F Y') }}.</p>
                    <p>Nature of authority given: "{{ $member->gdpr->last()->details }}"</p>
                </div>
            </div>
        @endif
        @if($member->comments)
            <div class="alert alert-warning">
                {{ $member->comments }}
            </div>
        @endif
    @endif
@endsection
