<?php namespace DistrictHub\Directory\Jobs;

use DistrictHub\Contracts\Gateways\Directory\ChurchGateway;
use DistrictHub\Directory\Events\ChurchWasUpdated;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;

class UpdateChurch
{
    use SerializesModels;

    protected $id;

    protected $attributes;

    /**
     * Create a new command instance.
     *
     * @param int   $id
     * @param array $attributes
     *
     * @return void
     */
    public function __construct($id, array $attributes)
    {
        $this->id = $id;
        $this->attributes = $attributes;
    }

    /**
     * Execute the command.
     *
     * @return void
     */
    public function handle(ChurchGateway $churchGateway)
    {
        if ($churchGateway->update($this->id, $this->attributes)) {
            $church = $churchGateway->find($this->id);
            event(new ChurchWasUpdated($church));
        }
    }
}
